/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.datatablet.pages.serializers;

import com.cmdpro.datanessence.api.datatablet.PageSerializer;
import com.cmdpro.datanessence.data.datatablet.pages.ItemPage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public class ItemPageSerializer
extends PageSerializer<ItemPage> {
    public static final ItemPageSerializer INSTANCE = new ItemPageSerializer();
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemPage> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        ComponentSerialization.STREAM_CODEC.encode(pBuffer, (Object)pValue.text);
        pBuffer.writeBoolean(pValue.rtl);
        ItemStack.STREAM_CODEC.encode(pBuffer, (Object)pValue.item);
    }, pBuffer -> {
        Component text = (Component)ComponentSerialization.STREAM_CODEC.decode(pBuffer);
        boolean rtl = pBuffer.readBoolean();
        ItemStack item = (ItemStack)ItemStack.STREAM_CODEC.decode(pBuffer);
        return new ItemPage(text, rtl, item);
    });
    public static final MapCodec<ItemPage> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ComponentSerialization.CODEC.optionalFieldOf("text", (Object)Component.empty()).forGetter(page -> page.text), (App)Codec.BOOL.optionalFieldOf("rtl", (Object)false).forGetter(page -> page.rtl), (App)ItemStack.CODEC.fieldOf("item").forGetter(page -> page.item)).apply((Applicative)instance, ItemPage::new));

    @Override
    public MapCodec<ItemPage> getCodec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ItemPage> getStreamCodec() {
        return STREAM_CODEC;
    }
}

