/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.datatablet.pages;

import com.cmdpro.datanessence.api.datatablet.Page;
import com.cmdpro.datanessence.api.datatablet.PageSerializer;
import com.cmdpro.datanessence.data.datatablet.pages.serializers.TextPageSerializer;
import com.cmdpro.datanessence.screen.DataTabletScreen;
import com.ibm.icu.lang.UCharacter;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.FormattedBidiReorder;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.SubStringSource;
import net.minecraft.util.FormattedCharSequence;

public class TextPage
extends Page {
    public Component text;
    public boolean rtl;

    public TextPage(Component text, boolean rtl) {
        this.text = text;
        this.rtl = rtl;
    }

    public int textYOffset() {
        return 0;
    }

    @Override
    public void render(DataTabletScreen screen, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int xOffset, int yOffset) {
        List text = Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)this.text, DataTabletScreen.imageWidth - 22, Style.EMPTY);
        int offsetY = 0;
        for (FormattedText i : text) {
            int x = xOffset + 11;
            FormattedCharSequence formattedCharSequence = FormattedBidiReorder.reorder((FormattedText)i, (boolean)Language.getInstance().isDefaultRightToLeft());
            if (this.rtl) {
                x = xOffset + (DataTabletScreen.imageWidth - 11 - Minecraft.getInstance().font.width(i));
                SubStringSource substr = SubStringSource.create((FormattedText)i, UCharacter::getMirror, str -> str);
                formattedCharSequence = FormattedCharSequence.composite((List)substr.substring(0, substr.getPlainText().length(), true));
            }
            pGuiGraphics.drawString(Minecraft.getInstance().font, formattedCharSequence, x, yOffset + 4 + offsetY + this.textYOffset(), -1);
            Objects.requireNonNull(Minecraft.getInstance().font);
            offsetY += 9 + 2;
        }
    }

    @Override
    public int getMaxScrollY() {
        List text = Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)this.text, DataTabletScreen.imageWidth - 22, Style.EMPTY);
        Objects.requireNonNull(Minecraft.getInstance().font);
        return (9 + 2) * text.size() + this.textYOffset() + 4;
    }

    @Override
    public PageSerializer getSerializer() {
        return TextPageSerializer.INSTANCE;
    }
}

