/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.datatablet.pages;

import com.cmdpro.datanessence.api.datatablet.CraftingType;
import com.cmdpro.datanessence.api.datatablet.CraftingTypes;
import com.cmdpro.datanessence.api.datatablet.PageSerializer;
import com.cmdpro.datanessence.data.datatablet.pages.TextPage;
import com.cmdpro.datanessence.data.datatablet.pages.serializers.CraftingPageSerializer;
import com.cmdpro.datanessence.screen.DataTabletScreen;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;

public class CraftingPage
extends TextPage {
    public List<ResourceLocation> recipes;
    public List<FormattedCharSequence> tooltipToShow = new ArrayList<FormattedCharSequence>();
    public boolean showTooltip;

    public CraftingPage(Component text, boolean rtl, List<ResourceLocation> recipes) {
        super(text, rtl);
        this.recipes = recipes;
    }

    @Override
    public int textYOffset() {
        int x = 4;
        int y = 4;
        int o = 0;
        for (ResourceLocation i : this.recipes) {
            x += 125;
            if (o >= 2) {
                x = 4;
                y += 62;
                o = 0;
            }
            ++o;
        }
        return y + 58;
    }

    @Override
    public void render(DataTabletScreen screen, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int xOffset, int yOffset) {
        super.render(screen, pGuiGraphics, pPartialTick, pMouseX, pMouseY, xOffset, yOffset);
        int x = 4;
        int y = 4;
        int p = 0;
        for (ResourceLocation i : this.recipes) {
            Optional optional = Minecraft.getInstance().level.getRecipeManager().byKey(i);
            if (optional.isPresent()) {
                for (CraftingType o : CraftingTypes.types) {
                    if (!o.isRecipeType(((RecipeHolder)optional.get()).value())) continue;
                    o.render(this, screen, pGuiGraphics, xOffset, x, yOffset, y, ((RecipeHolder)optional.get()).value(), pMouseX, pMouseY);
                    break;
                }
            }
            x += 125;
            if (++p < 2) continue;
            x = 4;
            y += 62;
            p = 0;
        }
    }

    @Override
    public void renderPost(DataTabletScreen screen, GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int xOffset, int yOffset) {
        super.renderPost(screen, pGuiGraphics, pPartialTick, pMouseX, pMouseY, xOffset, yOffset);
        if (this.showTooltip) {
            this.showTooltip = false;
            pGuiGraphics.renderTooltip(Minecraft.getInstance().font, this.tooltipToShow, pMouseX, pMouseY);
        }
    }

    public void renderItemWithTooltip(GuiGraphics graphics, ItemStack item, int x, int y, int mouseX, int mouseY) {
        graphics.renderItem(item, x, y);
        graphics.renderItemDecorations(Minecraft.getInstance().font, item, x, y);
        if (mouseX >= x && mouseY >= y && mouseX <= x + 16 && mouseY <= y + 16) {
            this.showTooltip = true;
            this.tooltipToShow.clear();
            for (Component i : Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)item)) {
                this.tooltipToShow.add(i.getVisualOrderText());
            }
        }
    }

    public void renderIngredientWithTooltip(DataTabletScreen screen, GuiGraphics graphics, Ingredient item, int x, int y, int mouseX, int mouseY) {
        if (!item.isEmpty()) {
            ItemStack currentItem = item.getItems()[screen.ticks / 20 % item.getItems().length];
            graphics.renderItem(currentItem, x, y);
            if (mouseX >= x && mouseY >= y && mouseX <= x + 16 && mouseY <= y + 16) {
                this.showTooltip = true;
                this.tooltipToShow.clear();
                for (Component i : Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)currentItem)) {
                    this.tooltipToShow.add(i.getVisualOrderText());
                }
            }
        }
    }

    public void renderFluidIngredientWithTooltip(DataTabletScreen screen, GuiGraphics graphics, FluidIngredient fluid, int x, int y, int mouseX, int mouseY) {
        if (!fluid.isEmpty()) {
            FluidStack currentFluid = fluid.getStacks()[screen.ticks / 20 % fluid.getStacks().length];
            this.renderFluidWithTooltip(graphics, currentFluid, x, y, mouseX, mouseY);
        }
    }

    public void renderFluidWithTooltip(GuiGraphics graphics, FluidStack fluid, int x, int y, int mouseX, int mouseY) {
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getStillTexture(fluid);
        if (stillTexture != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
            int tintColor = fluidTypeExtensions.getTintColor(fluid);
            Color tint = new Color(tintColor);
            graphics.blit(x, y, 0, 16, 16, sprite, (float)tint.getRed() / 255.0f, (float)tint.getGreen() / 255.0f, (float)tint.getBlue() / 255.0f, (float)tint.getAlpha() / 255.0f);
        }
        if (mouseX <= x + 16 && mouseY <= y + 16 && mouseX >= x && mouseY >= y) {
            if (!fluid.isEmpty()) {
                this.showTooltip = true;
                this.tooltipToShow.clear();
                this.tooltipToShow.add(Component.translatable((String)"gui.widget.fluid.without_max", (Object[])new Object[]{fluid.getAmount(), fluid.getHoverName()}).getVisualOrderText());
            } else {
                this.showTooltip = true;
                this.tooltipToShow.clear();
                this.tooltipToShow.add(Component.empty().getVisualOrderText());
            }
        }
    }

    @Override
    public PageSerializer getSerializer() {
        return CraftingPageSerializer.INSTANCE;
    }
}

