/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.datatablet;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.datatablet.Page;
import com.cmdpro.datanessence.api.datatablet.PageSerializer;
import com.cmdpro.datanessence.data.datatablet.CompletionStage;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;

public class EntrySerializer {
    public static final Codec<Page> PAGE_CODEC = DataNEssenceRegistries.PAGE_TYPE_REGISTRY.byNameCodec().dispatch(Page::getSerializer, pageSerializer -> pageSerializer.getCodec());
    public static final StreamCodec<RegistryFriendlyByteBuf, Page> PAGE_STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeResourceLocation(DataNEssenceRegistries.PAGE_TYPE_REGISTRY.getKey((Object)pValue.getSerializer()));
        pValue.getSerializer().getStreamCodec().encode(pBuffer, pValue);
    }, pBuffer -> {
        ResourceLocation type = pBuffer.readResourceLocation();
        PageSerializer pageSerializer = (PageSerializer)DataNEssenceRegistries.PAGE_TYPE_REGISTRY.get(type);
        Page page = (Page)pageSerializer.getStreamCodec().decode(pBuffer);
        return page;
    });
    public static final MapCodec<Entry> ORIGINAL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("icon").forGetter(entry -> entry.icon), (App)Codec.INT.fieldOf("x").forGetter(entry -> entry.x), (App)Codec.INT.fieldOf("y").forGetter(entry -> entry.y), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(entry -> entry.name), (App)ComponentSerialization.CODEC.optionalFieldOf("flavor", (Object)Component.empty()).forGetter(entry -> entry.flavor), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("parents", new ArrayList()).forGetter(entry -> entry.parents), (App)PAGE_CODEC.listOf().fieldOf("pages").forGetter(entry -> entry.pages), (App)Codec.BOOL.optionalFieldOf("critical", (Object)false).forGetter(entry -> entry.critical), (App)ResourceLocation.CODEC.fieldOf("tab").forGetter(entry -> entry.tab), (App)CompletionStage.CODEC.listOf().optionalFieldOf("completion_stages", new ArrayList()).forGetter(entry -> entry.completionStages), (App)Codec.BOOL.optionalFieldOf("is_default", (Object)false).forGetter(entry -> entry.isDefault)).apply((Applicative)instance, (icon, x, y, name, flavor, parents, pages, critical, tab, completionStages, isDefault) -> new Entry(null, (ResourceLocation)tab, (ItemStack)icon, (int)x, (int)y, (List<Page>)pages, (List<ResourceLocation>)parents, (Component)name, (Component)flavor, (boolean)critical, (List<CompletionStage>)completionStages, (boolean)isDefault)));
    public static final Codec<Optional<WithConditions<Entry>>> CODEC = ConditionalOps.createConditionalCodecWithConditions((Codec)ORIGINAL_CODEC.codec());
    public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeResourceLocation(pValue.id);
        pBuffer.writeInt(pValue.x);
        pBuffer.writeInt(pValue.y);
        ItemStack.STREAM_CODEC.encode(pBuffer, (Object)pValue.icon);
        ComponentSerialization.STREAM_CODEC.encode(pBuffer, (Object)pValue.name);
        ComponentSerialization.STREAM_CODEC.encode(pBuffer, (Object)pValue.flavor);
        pBuffer.writeCollection(pValue.pages, (pBuffer1, pValue1) -> PAGE_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)pBuffer1), pValue1));
        ArrayList<ResourceLocation> parents = new ArrayList<ResourceLocation>();
        for (Entry i : pValue.getParentEntries()) {
            parents.add(i.id);
        }
        pBuffer.writeCollection(parents, FriendlyByteBuf::writeResourceLocation);
        pBuffer.writeBoolean(pValue.critical);
        pBuffer.writeResourceLocation(pValue.tab);
        pBuffer.writeCollection(pValue.completionStages, (pBuffer1, pValue1) -> CompletionStage.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)pBuffer1), pValue1));
        pBuffer.writeBoolean(pValue.isDefault);
    }, pBuffer -> {
        ResourceLocation id = pBuffer.readResourceLocation();
        int x = pBuffer.readInt();
        int y = pBuffer.readInt();
        ItemStack icon = (ItemStack)ItemStack.STREAM_CODEC.decode(pBuffer);
        Component name = (Component)ComponentSerialization.STREAM_CODEC.decode(pBuffer);
        Component flavor = (Component)ComponentSerialization.STREAM_CODEC.decode(pBuffer);
        List pages = pBuffer.readList(pBuffer1 -> (Page)PAGE_STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)pBuffer1)));
        List parents = pBuffer.readList(FriendlyByteBuf::readResourceLocation);
        boolean critical = pBuffer.readBoolean();
        ResourceLocation tab = pBuffer.readResourceLocation();
        List completionStages = pBuffer.readList(pBuffer1 -> (CompletionStage)CompletionStage.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)pBuffer1)));
        boolean isDefault = pBuffer.readBoolean();
        return new Entry(id, tab, icon, x, y, (List<Page>)pages, (List<ResourceLocation>)parents, name, flavor, critical, (List<CompletionStage>)completionStages, isDefault);
    });

    public Entry read(ResourceLocation entryId, JsonObject json) {
        Entry entry = ICondition.getWithWithConditionsCodec(CODEC, (DynamicOps)JsonOps.INSTANCE, (Object)json).orElse(null);
        if (entry != null) {
            entry.id = entryId;
            return entry;
        }
        return null;
    }
}

