/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.datatablet;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.data.datatablet.EntrySerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class EntryManager
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static EntryManager instance;
    public static EntrySerializer serializer;

    protected EntryManager() {
        super(GSON, "datanessence/data_tablet/entries");
    }

    public static EntryManager getOrCreateInstance() {
        if (instance == null) {
            instance = new EntryManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        Entries.entries.clear();
        DataNEssence.LOGGER.info("[DATANESSENCE] Adding Data Tablet Entries");
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation location = entry.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                Entry entry2 = this.deserializeEntry(location, GsonHelper.convertToJsonObject((JsonElement)entry.getValue(), (String)"top member"));
                if (entry2 == null) continue;
                Entries.entries.put(entry.getKey(), entry2);
                DataNEssence.LOGGER.info("[DATANESSENCE] Successfully added entry {}", (Object)location);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DataNEssence.LOGGER.error("[DATANESSENCE ERROR] Parsing error loading entry {}", (Object)location, (Object)e);
            }
        }
        DataNEssence.LOGGER.info("[DATANESSENCE] Loaded {} Data Tablet Entries", (Object)Entries.entries.size());
        for (Entry entry : Entries.entries.values()) {
            for (Entry o : Entries.entries.values()) {
                if (entry == o || entry.x != o.x || entry.y != o.y || !entry.tab.equals((Object)o.tab)) continue;
                DataNEssence.LOGGER.warn("[DATANESSENCE] Data Tablet Entry \"" + String.valueOf(entry.id) + "\" is overlapping with entry \"" + String.valueOf(o.id) + "\"");
            }
            entry.updateParentEntries();
        }
    }

    protected Entry deserializeEntry(ResourceLocation id, JsonObject json) {
        EntrySerializer serializer = EntryManager.serializer;
        if (serializer != null) {
            return serializer.read(id, json);
        }
        return null;
    }

    static {
        serializer = new EntrySerializer();
    }
}

