/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.datatablet;

import com.cmdpro.datanessence.api.datatablet.Page;
import com.cmdpro.datanessence.data.datatablet.CompletionStage;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.moddata.ClientPlayerUnlockedEntries;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class Entry {
    public ResourceLocation tab;
    public boolean critical;
    public Component name;
    public Component flavor;
    public ItemStack icon;
    public ResourceLocation id;
    public int x;
    public int y;
    public List<Page> pages;
    public List<ResourceLocation> parents;
    private List<Entry> parentEntries;
    public List<CompletionStage> completionStages;
    public boolean isDefault;

    public Entry(ResourceLocation id, ResourceLocation tab, ItemLike icon, int x, int y, List<Page> pages, List<ResourceLocation> parents, Component name, Component flavor, boolean critical, List<CompletionStage> completionStages, boolean isDefault) {
        this.id = id;
        this.icon = new ItemStack(icon);
        this.x = x;
        this.y = y;
        this.pages = pages;
        this.parents = parents;
        this.name = name;
        this.flavor = flavor;
        this.critical = critical;
        this.tab = tab;
        this.completionStages = completionStages;
        this.isDefault = isDefault;
    }

    public Entry(ResourceLocation id, ResourceLocation tab, ItemStack icon, int x, int y, List<Page> pages, List<ResourceLocation> parents, Component name, Component flavor, boolean critical, List<CompletionStage> completionStages, boolean isDefault) {
        this.id = id;
        this.icon = icon;
        this.x = x;
        this.y = y;
        this.pages = pages;
        this.parents = parents;
        this.name = name;
        this.flavor = flavor;
        this.critical = critical;
        this.tab = tab;
        this.completionStages = completionStages;
        this.isDefault = isDefault;
    }

    public ItemStack getIcon(int stage) {
        return this.isIncomplete(stage) ? this.completionStages.get((int)stage).iconOverride.orElse(this.icon) : this.icon;
    }

    public Component getName(int stage) {
        return this.isIncomplete(stage) ? this.completionStages.get((int)stage).nameOverride.orElse(this.name) : this.name;
    }

    public Component getFlavor(int stage) {
        return this.isIncomplete(stage) ? this.completionStages.get((int)stage).flavorOverride.orElse(this.flavor) : this.flavor;
    }

    public List<Page> getPagesClient() {
        return this.isIncompleteClient() ? this.completionStages.get((int)this.getIncompleteStageClient()).pages : this.pages;
    }

    public int getIncompleteStageClient() {
        return ClientPlayerUnlockedEntries.getIncomplete().getOrDefault(this.id, ClientPlayerUnlockedEntries.getUnlocked().contains(this.id) ? this.completionStages.size() : 0);
    }

    public boolean isIncompleteClient() {
        return this.isIncomplete(this.getIncompleteStageClient());
    }

    public boolean isVisibleClient() {
        return this.isUnlockedClient() && (ClientPlayerUnlockedEntries.getUnlocked().contains(this.id) || ClientPlayerUnlockedEntries.getIncomplete().containsKey(this.id));
    }

    public boolean isUnlockedClient() {
        boolean unlocked = true;
        for (Entry i : this.getParentEntries()) {
            if (ClientPlayerUnlockedEntries.getUnlocked().contains(i.id)) continue;
            unlocked = false;
            break;
        }
        return unlocked;
    }

    public boolean isUnlockedServer(Player player) {
        List unlockedEntries = (List)player.getData(AttachmentTypeRegistry.UNLOCKED);
        boolean unlocked = true;
        for (Entry i : this.getParentEntries()) {
            if (unlockedEntries.contains(i.id)) continue;
            unlocked = false;
            break;
        }
        return unlocked;
    }

    public int getIncompleteStageServer(Player player) {
        return ((HashMap)player.getData(AttachmentTypeRegistry.INCOMPLETE_STAGES)).getOrDefault(this.id, ((ArrayList)player.getData(AttachmentTypeRegistry.UNLOCKED)).contains(this.id) ? this.completionStages.size() : -1);
    }

    public boolean isIncompleteServer(Player player) {
        return this.isIncomplete(this.getIncompleteStageServer(player));
    }

    public boolean isIncomplete(int stage) {
        return stage < this.completionStages.size();
    }

    public List<Entry> getParentEntries() {
        return this.parentEntries;
    }

    public void setParentEntries(List<ResourceLocation> entry) {
        this.parents = entry;
        this.updateParentEntries();
    }

    public boolean updateParentEntries() {
        ArrayList<Entry> parentEntries = new ArrayList<Entry>();
        for (ResourceLocation i : this.parents) {
            if (!Entries.entries.containsKey(i)) continue;
            parentEntries.add(Entries.entries.get(i));
        }
        this.parentEntries = parentEntries;
        return !parentEntries.isEmpty();
    }
}

