/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.datatablet;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.data.datatablet.DataTab;
import com.cmdpro.datanessence.data.datatablet.DataTabSerializer;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class DataTabManager
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static DataTabManager instance;
    public static DataTabSerializer serializer;

    protected DataTabManager() {
        super(GSON, "datanessence/data_tablet/tabs");
    }

    public static DataTabManager getOrCreateInstance() {
        if (instance == null) {
            instance = new DataTabManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        Object before;
        Entries.tabs.clear();
        DataNEssence.LOGGER.info("[DATANESSENCE] Adding Data Tablet Tabs");
        for (Map.Entry<ResourceLocation, JsonElement> i2 : pObject.entrySet()) {
            ResourceLocation location = i2.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                DataTab tab = this.deserializeTab(location, GsonHelper.convertToJsonObject((JsonElement)i2.getValue(), (String)"top member"));
                if (tab == null) continue;
                Entries.tabs.put(i2.getKey(), tab);
                DataNEssence.LOGGER.info("[DATANESSENCE] Successfully added tab {}", (Object)location);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DataNEssence.LOGGER.error("[DATANESSENCE ERROR] Parsing error loading tab {}", (Object)location, (Object)e);
            }
        }
        DataNEssence.LOGGER.info("[DATANESSENCE] Loaded {} Data Tablet Tabs", (Object)Entries.tabs.size());
        HashMap<DataTab.DataTabPlacement, List> placements = new HashMap<DataTab.DataTabPlacement, List>();
        DataTab.DataTabPlacement bothIgnored = new DataTab.DataTabPlacement(DataTab.DataTabPlacement.IGNORED, DataTab.DataTabPlacement.IGNORED);
        DataTab.DataTabPlacement bothAll = new DataTab.DataTabPlacement(DataTab.DataTabPlacement.ALL, DataTab.DataTabPlacement.ALL);
        placements.put(bothIgnored, new ArrayList());
        placements.put(bothAll, new ArrayList());
        for (DataTab i3 : Entries.tabs.values()) {
            List list = placements.getOrDefault(i3.placement, new ArrayList());
            list.add(i3);
            placements.put(i3.placement, list);
        }
        ArrayList<DataTab> sorted = new ArrayList<DataTab>((Collection)placements.get(bothIgnored));
        ArrayList toSort = new ArrayList();
        placements.entrySet().stream().filter(i -> i.getKey() != bothAll).filter(i -> ((DataTab.DataTabPlacement)i.getKey()).placeBefore().equals((Object)DataTab.DataTabPlacement.ALL) || ((DataTab.DataTabPlacement)i.getKey()).placeAfter().equals((Object)DataTab.DataTabPlacement.ALL)).map(Map.Entry::getValue).forEach(toSort::addAll);
        for (DataTab i4 : toSort) {
            if (i4.placement.placeBefore().equals((Object)DataTab.DataTabPlacement.ALL)) {
                if (i4.placement.placeAfter().equals((Object)DataTab.DataTabPlacement.ALL)) {
                    DataNEssence.LOGGER.error("[DATANESSENCE ERROR] Unable to sort {}, both \"place_after\" and \"place_before\" are set to \"datanessence:all\"", (Object)i4.id);
                    continue;
                }
                if (!i4.placement.placeAfter().equals((Object)DataTab.DataTabPlacement.IGNORED)) {
                    DataNEssence.LOGGER.error("[DATANESSENCE ERROR] Unable to sort {}, \"place_before\" is set to \"datanessence:all\" but place_after is not ignored", (Object)i4.id);
                    continue;
                }
                sorted.addFirst(i4);
                continue;
            }
            if (!i4.placement.placeAfter().equals((Object)DataTab.DataTabPlacement.ALL)) continue;
            if (!i4.placement.placeBefore().equals((Object)DataTab.DataTabPlacement.IGNORED)) {
                DataNEssence.LOGGER.error("[DATANESSENCE ERROR] Unable to sort {}, \"place_after\" is set to \"datanessence:all\" but place_before is not ignored", (Object)i4.id);
                continue;
            }
            sorted.addLast(i4);
        }
        toSort = new ArrayList();
        placements.entrySet().stream().filter(i -> !this.isSpecial(((DataTab.DataTabPlacement)i.getKey()).placeBefore()) || !this.isSpecial(((DataTab.DataTabPlacement)i.getKey()).placeAfter())).filter(i -> !((DataTab.DataTabPlacement)i.getKey()).placeBefore().equals((Object)DataTab.DataTabPlacement.ALL) && !((DataTab.DataTabPlacement)i.getKey()).placeAfter().equals((Object)DataTab.DataTabPlacement.ALL)).map(Map.Entry::getValue).forEach(toSort::addAll);
        ArrayList<DataTab> errored = new ArrayList<DataTab>(new ArrayList(toSort).stream().filter(i -> !Entries.tabs.containsKey(i.placement.placeBefore()) && !this.isSpecial(i.placement.placeBefore()) || !Entries.tabs.containsKey(i.placement.placeAfter()) && !this.isSpecial(i.placement.placeAfter()) || i.id.equals((Object)i.placement.placeBefore()) || i.id.equals((Object)i.placement.placeAfter())).toList());
        toSort.removeAll(errored);
        for (DataTab i5 : errored) {
            boolean afterErrored;
            boolean beforeErrored = !Entries.tabs.containsKey(i5.placement.placeBefore());
            boolean bl = afterErrored = !Entries.tabs.containsKey(i5.placement.placeBefore());
            if (beforeErrored && afterErrored) {
                before = i5.placement.placeBefore().toString();
                String after = i5.placement.placeBefore().toString();
                DataNEssence.LOGGER.error("[DATANESSENCE ERROR] Unable to sort {}, both \"{}\" and \"{}\" dont exist", new Object[]{i5.id, before, after});
                continue;
            }
            String erroredValue = beforeErrored ? i5.placement.placeBefore().toString() : (afterErrored ? i5.placement.placeAfter().toString() : "unknown");
            DataNEssence.LOGGER.error("[DATANESSENCE ERROR] Unable to sort {}, \"{}\" doesnt exist", (Object)i5.id, (Object)erroredValue);
        }
        errored.clear();
        while (!toSort.isEmpty()) {
            for (DataTab i5 : new ArrayList(toSort)) {
                int index = -1;
                Optional<DataTab> after = sorted.stream().filter(j -> j.id.equals((Object)i.placement.placeAfter())).findFirst();
                if (!this.isSpecial(i5.placement.placeAfter())) {
                    if (!after.isPresent()) continue;
                    index = sorted.indexOf(after.get()) + 1;
                }
                before = sorted.stream().filter(j -> j.id.equals((Object)i.placement.placeBefore())).findFirst();
                if (!this.isSpecial(i5.placement.placeBefore())) {
                    if (!((Optional)before).isPresent()) continue;
                    if (index != -1) {
                        int max = sorted.indexOf(((Optional)before).get());
                        if (index > max) {
                            index = max;
                        }
                    } else {
                        index = sorted.indexOf(((Optional)before).get());
                    }
                }
                if (index == -1) continue;
                sorted.add(index, i5);
                toSort.remove(i5);
            }
        }
        Entries.tabsSorted = sorted;
        DataNEssence.LOGGER.info("[DATANESSENCE] Sorted {} Data Tablet Tabs", (Object)Entries.tabsSorted.size());
    }

    private boolean isSpecial(ResourceLocation placement) {
        return placement.equals((Object)DataTab.DataTabPlacement.ALL) || placement.equals((Object)DataTab.DataTabPlacement.IGNORED);
    }

    protected DataTab deserializeTab(ResourceLocation id, JsonObject json) {
        DataTabSerializer serializer = DataTabManager.serializer;
        if (serializer != null) {
            return serializer.read(id, json);
        }
        return null;
    }

    static {
        serializer = new DataTabSerializer();
    }
}

