/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.databank;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.databank.MinigameCreator;
import com.cmdpro.datanessence.api.databank.MinigameSerializer;
import com.cmdpro.datanessence.data.databank.DataBankEntry;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;

public class DataBankEntrySerializer {
    public static final Codec<MinigameCreator> MINIGAME_CODEC = DataNEssenceRegistries.MINIGAME_TYPE_REGISTRY.byNameCodec().dispatch(MinigameCreator::getSerializer, MinigameSerializer::getCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, MinigameCreator> MINIGAME_STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeResourceLocation(DataNEssenceRegistries.MINIGAME_TYPE_REGISTRY.getKey((Object)pValue.getSerializer()));
        pValue.getSerializer().getStreamCodec().encode(pBuffer, pValue);
    }, pBuffer -> {
        ResourceLocation type = pBuffer.readResourceLocation();
        MinigameSerializer minigameSerializer = (MinigameSerializer)DataNEssenceRegistries.MINIGAME_TYPE_REGISTRY.get(type);
        MinigameCreator page = (MinigameCreator)minigameSerializer.getStreamCodec().decode(pBuffer);
        return page;
    });
    public static final MapCodec<DataBankEntry> ORIGINAL_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("icon").forGetter(entry -> entry.icon), (App)Codec.INT.fieldOf("tier").forGetter(entry -> entry.tier), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(entry -> entry.name), (App)MINIGAME_CODEC.listOf().optionalFieldOf("minigames", new ArrayList()).forGetter(entry -> List.of(entry.minigames)), (App)ResourceLocation.CODEC.fieldOf("entry").forGetter(entry -> entry.entry)).apply((Applicative)instance, (icon, tier, name, minigames, entry) -> new DataBankEntry(null, (ItemStack)icon, (int)tier, minigames.toArray(new MinigameCreator[0]), (Component)name, (ResourceLocation)entry)));
    public static final Codec<Optional<WithConditions<DataBankEntry>>> CODEC = ConditionalOps.createConditionalCodecWithConditions((Codec)ORIGINAL_CODEC.codec());
    public static final StreamCodec<RegistryFriendlyByteBuf, DataBankEntry> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeResourceLocation(pValue.id);
        ItemStack.STREAM_CODEC.encode(pBuffer, (Object)pValue.icon);
        ComponentSerialization.STREAM_CODEC.encode(pBuffer, (Object)pValue.name);
        pBuffer.writeInt(pValue.tier);
        pBuffer.writeCollection(Arrays.stream(pValue.minigames).toList(), (pBuffer1, pValue1) -> MINIGAME_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)pBuffer1), pValue1));
        pBuffer.writeResourceLocation(pValue.entry);
    }, pBuffer -> {
        ResourceLocation id = pBuffer.readResourceLocation();
        ItemStack icon = (ItemStack)ItemStack.STREAM_CODEC.decode(pBuffer);
        Component name = (Component)ComponentSerialization.STREAM_CODEC.decode(pBuffer);
        int tier = pBuffer.readInt();
        MinigameCreator[] minigames = pBuffer.readList(pBuffer1 -> (MinigameCreator)MINIGAME_STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)pBuffer1))).toArray(new MinigameCreator[0]);
        ResourceLocation entry2 = pBuffer.readResourceLocation();
        DataBankEntry entry = new DataBankEntry(id, icon, tier, minigames, name, entry2);
        return entry;
    });

    public DataBankEntry read(ResourceLocation entryId, JsonObject json) {
        DataBankEntry entry = ICondition.getWithWithConditionsCodec(CODEC, (DynamicOps)JsonOps.INSTANCE, (Object)json).orElse(null);
        if (entry != null) {
            entry.id = entryId;
            return entry;
        }
        return null;
    }
}

