/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.databank;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.data.databank.DataBankEntries;
import com.cmdpro.datanessence.data.databank.DataBankEntry;
import com.cmdpro.datanessence.data.databank.DataBankEntrySerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class DataBankEntryManager
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static DataBankEntryManager instance;
    public static DataBankEntrySerializer serializer;

    protected DataBankEntryManager() {
        super(GSON, "datanessence/data_tablet/data_bank_entries");
    }

    public static DataBankEntryManager getOrCreateInstance() {
        if (instance == null) {
            instance = new DataBankEntryManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        DataBankEntries.entries.clear();
        DataNEssence.LOGGER.info("[DATANESSENCE] Adding Data Bank Entries");
        for (Map.Entry<ResourceLocation, JsonElement> i : pObject.entrySet()) {
            ResourceLocation location = i.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                DataBankEntry entry = this.deserializeEntry(location, GsonHelper.convertToJsonObject((JsonElement)i.getValue(), (String)"top member"));
                if (entry == null) continue;
                DataBankEntries.entries.put(i.getKey(), entry);
                DataNEssence.LOGGER.info("[DATANESSENCE] Successfully added entry {}", (Object)location);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DataNEssence.LOGGER.error("[DATANESSENCE ERROR] Parsing error loading data bank entry {}", (Object)location, (Object)e);
            }
        }
        DataNEssence.LOGGER.info("[DATANESSENCE] Loaded {} Data Bank Entries", (Object)DataBankEntries.entries.size());
    }

    protected DataBankEntry deserializeEntry(ResourceLocation id, JsonObject json) {
        DataBankEntrySerializer serializer = DataBankEntryManager.serializer;
        if (serializer != null) {
            return serializer.read(id, json);
        }
        return null;
    }

    static {
        serializer = new DataBankEntrySerializer();
    }
}

