/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.computers.files.types;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.computer.ComputerFileType;
import com.cmdpro.datanessence.data.computers.files.TextFile;
import com.cmdpro.datanessence.screen.DataTabletScreen;
import com.ibm.icu.lang.UCharacter;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.FormattedBidiReorder;
import net.minecraft.locale.Language;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.SubStringSource;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.FormattedCharSequence;

public class TextFileType
extends ComputerFileType<TextFile> {
    public static final MapCodec<TextFile> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ComponentSerialization.CODEC.fieldOf("text").forGetter(file -> file.text), (App)Codec.BOOL.optionalFieldOf("rtl", (Object)false).forGetter(page -> page.rtl)).apply((Applicative)instance, TextFile::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TextFile> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        ComponentSerialization.STREAM_CODEC.encode(pBuffer, (Object)pValue.text);
        pBuffer.writeBoolean(pValue.rtl);
    }, pBuffer -> {
        Component text = (Component)ComponentSerialization.STREAM_CODEC.decode(pBuffer);
        boolean rtl = pBuffer.readBoolean();
        return new TextFile(text, rtl);
    });

    @Override
    public MapCodec<TextFile> getCodec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, TextFile> getStreamCodec() {
        return STREAM_CODEC;
    }

    @Override
    public ComputerFileType.ComputerFileIcon getIcon(TextFile file) {
        return new ComputerFileType.ComputerFileIcon(this, DataNEssence.locate("textures/gui/computer.png"), 0, 166, 16, 16);
    }

    @Override
    public void renderScreen(TextFile file, GuiGraphics graphics, double mouseX, double mouseY, float delta, int xOffset, int yOffset) {
        MutableComponent component = file.text.copy();
        List text = Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)component, DataTabletScreen.imageWidth - 8, Style.EMPTY);
        int offsetY = 0;
        for (FormattedText i : text) {
            int x = xOffset + 4;
            FormattedCharSequence formattedCharSequence = FormattedBidiReorder.reorder((FormattedText)i, (boolean)Language.getInstance().isDefaultRightToLeft());
            if (file.rtl) {
                x = xOffset + (DataTabletScreen.imageWidth - 4 - Minecraft.getInstance().font.width(i));
                SubStringSource substr = SubStringSource.create((FormattedText)i, UCharacter::getMirror, str -> str);
                formattedCharSequence = FormattedCharSequence.composite((List)substr.substring(0, substr.getPlainText().length(), true));
            }
            graphics.drawString(Minecraft.getInstance().font, formattedCharSequence, x, yOffset + 4 + offsetY, -1);
            Objects.requireNonNull(Minecraft.getInstance().font);
            offsetY += 9 + 2;
        }
    }
}

