/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.computers;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.computer.ComputerFile;
import com.cmdpro.datanessence.api.computer.ComputerFileType;
import com.cmdpro.datanessence.data.computers.ComputerData;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class ComputerTypeSerializer {
    public static final Codec<ComputerFile> FILE_CODEC = DataNEssenceRegistries.COMPUTER_FILE_TYPES_REGISTRY.byNameCodec().dispatch(ComputerFile::getType, computerFileType -> computerFileType.getCodec());
    public static final StreamCodec<RegistryFriendlyByteBuf, ComputerFile> FILE_STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeResourceLocation(DataNEssenceRegistries.COMPUTER_FILE_TYPES_REGISTRY.getKey((Object)pValue.getType()));
        pValue.getType().getStreamCodec().encode(pBuffer, pValue);
    }, pBuffer -> {
        ResourceLocation type = pBuffer.readResourceLocation();
        ComputerFileType minigameSerializer = (ComputerFileType)DataNEssenceRegistries.COMPUTER_FILE_TYPES_REGISTRY.get(type);
        ComputerFile page = (ComputerFile)minigameSerializer.getStreamCodec().decode(pBuffer);
        return page;
    });
    public static final MapCodec<ComputerData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FILE_CODEC.listOf().fieldOf("files").forGetter(data -> data.files)).apply((Applicative)instance, ComputerData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ComputerData> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> pBuffer.writeCollection(pValue.files, (buf, val) -> FILE_STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf), val)), pBuffer -> {
        List files = pBuffer.readList(buf -> (ComputerFile)FILE_STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf)));
        ComputerData data = new ComputerData(files);
        return data;
    });

    public ComputerData read(ResourceLocation entryId, JsonObject json) {
        ComputerData data = (ComputerData)CODEC.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
        return data;
    }
}

