/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.data.computers;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.data.computers.ComputerData;
import com.cmdpro.datanessence.data.computers.ComputerTypeSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class ComputerTypeManager
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static ComputerTypeManager instance;
    public static Map<ResourceLocation, ComputerData> types;
    public static ComputerTypeSerializer serializer;

    protected ComputerTypeManager() {
        super(GSON, "datanessence/computer_types");
    }

    public static ComputerTypeManager getOrCreateInstance() {
        if (instance == null) {
            instance = new ComputerTypeManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        types = new HashMap<ResourceLocation, ComputerData>();
        DataNEssence.LOGGER.info("[DATANESSENCE] Adding Computer Types");
        for (Map.Entry<ResourceLocation, JsonElement> i : pObject.entrySet()) {
            ResourceLocation location = i.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                JsonObject obj = i.getValue().getAsJsonObject();
                ComputerData data = serializer.read(i.getKey(), obj);
                types.put(i.getKey(), data);
                DataNEssence.LOGGER.info("[DATANESSENCE] Successfully added computer type {}", (Object)location);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DataNEssence.LOGGER.error("[DATANESSENCE] Parsing error loading computer type {}", (Object)location, (Object)e);
            }
        }
        DataNEssence.LOGGER.info("[DATANESSENCE] Loaded {} computer types", (Object)types.size());
    }

    static {
        serializer = new ComputerTypeSerializer();
    }
}

