/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.config;

import com.cmdpro.datanessence.DataNEssence;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DataNEssenceConfig {
    public static final ModConfigSpec COMMON_SPEC;
    public static final DataNEssenceConfig COMMON;
    public static int fluidPointTransfer;
    public static int essencePointTransfer;
    public static int itemPointTransfer;
    public static int essenceBatteryMax;
    public static int maxNodeWires;
    public static int wireDistanceLimit;
    public final ModConfigSpec.IntValue fluidPointTransferValue;
    public final ModConfigSpec.IntValue essencePointTransferValue;
    public final ModConfigSpec.IntValue itemPointTransferValue;
    public final ModConfigSpec.IntValue essenceBatteryMaxValue;
    public final ModConfigSpec.IntValue maxNodeWiresValue;
    public final ModConfigSpec.IntValue wireDistanceLimitValue;

    public DataNEssenceConfig(ModConfigSpec.Builder builder) {
        builder.push("balancing");
        this.fluidPointTransferValue = DataNEssenceConfig.buildInteger(builder, "fluidNodeTransfer", 125, 1, 1000000, "The base, un-upgraded rate that Fluid Nodes can transfer, in mB per tick. (Also applies to Chemical Nodes if Mekanism is installed)");
        this.essencePointTransferValue = DataNEssenceConfig.buildInteger(builder, "essenceNodeTransfer", 50, 1, 1000000, "The base, un-upgraded rate that all Essence Nodes can transfer per tick.");
        this.itemPointTransferValue = DataNEssenceConfig.buildInteger(builder, "itemNodeTransfer", 4, 1, 64, "The base, un-upgraded rate that Item Nodes can transfer, in items per tick.");
        this.essenceBatteryMaxValue = DataNEssenceConfig.buildInteger(builder, "essenceBatteryMax", 10000, 1, 1000000, "The capacity for all Essence Batteries.");
        this.maxNodeWiresValue = DataNEssenceConfig.buildInteger(builder, "maxNodeWires", 4, 1, 50, "Connection limit for all Nodes - a Node cannot have more Wires than this.");
        this.wireDistanceLimitValue = DataNEssenceConfig.buildInteger(builder, "wireDistanceLimit", 24, 1, 64, "Distance limit for wire length, in blocks.");
    }

    private static ModConfigSpec.BooleanValue buildBoolean(ModConfigSpec.Builder builder, String name, boolean defaultValue, String comment) {
        return builder.comment(comment).translation(name).define(name, defaultValue);
    }

    private static ModConfigSpec.IntValue buildInteger(ModConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    private static ModConfigSpec.DoubleValue buildDouble(ModConfigSpec.Builder builder, String name, double defaultValue, double min, double max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    public static void bake(ModConfig config) {
        try {
            fluidPointTransfer = (Integer)DataNEssenceConfig.COMMON.fluidPointTransferValue.get();
            essencePointTransfer = (Integer)DataNEssenceConfig.COMMON.essencePointTransferValue.get();
            itemPointTransfer = (Integer)DataNEssenceConfig.COMMON.itemPointTransferValue.get();
            essenceBatteryMax = (Integer)DataNEssenceConfig.COMMON.essenceBatteryMaxValue.get();
            maxNodeWires = (Integer)DataNEssenceConfig.COMMON.maxNodeWiresValue.get();
            wireDistanceLimit = (Integer)DataNEssenceConfig.COMMON.wireDistanceLimitValue.get();
        }
        catch (Exception e) {
            DataNEssence.LOGGER.warn("[DATANESSENCE] Failed to load config!");
            e.printStackTrace();
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(DataNEssenceConfig::new);
        COMMON = (DataNEssenceConfig)specPair.getLeft();
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        fluidPointTransfer = 125;
        essencePointTransfer = 50;
        itemPointTransfer = 4;
        essenceBatteryMax = 50;
        maxNodeWires = 4;
        wireDistanceLimit = 24;
    }
}

