/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.config;

import com.cmdpro.datanessence.DataNEssence;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DataNEssenceClientConfig {
    public static final ModConfigSpec CLIENT_SPEC;
    public static final DataNEssenceClientConfig CLIENT;
    public static boolean genderEuphoriaShader;
    public static boolean pingShader;
    public static boolean progressionShader;
    public static boolean colorAssist;
    public final ModConfigSpec.BooleanValue genderEuphoriaShaderValue;
    public final ModConfigSpec.BooleanValue pingShaderValue;
    public final ModConfigSpec.BooleanValue progressionShaderValue;
    public final ModConfigSpec.BooleanValue colorAssistValue;

    public DataNEssenceClientConfig(ModConfigSpec.Builder builder) {
        builder.push("shaders");
        this.genderEuphoriaShaderValue = DataNEssenceClientConfig.buildBoolean(builder, "genderEuphoriaShader", true, "Should the gender euphoria shader be enabled?");
        this.pingShaderValue = DataNEssenceClientConfig.buildBoolean(builder, "pingShader", true, "Should the signal tracker ping shader be enabled?");
        this.progressionShaderValue = DataNEssenceClientConfig.buildBoolean(builder, "progressionShader", true, "Should the progression shader be enabled?");
        builder.pop();
        builder.push("accessibility");
        this.colorAssistValue = DataNEssenceClientConfig.buildBoolean(builder, "colorAssist", false, "Whether to enable color-assist mode. When on, various tweaks to color-dependent puzzles will be made to hopefully help in their completion, or in the case of one puzzle, will be outright bypassed.");
        builder.pop();
    }

    private static ModConfigSpec.BooleanValue buildBoolean(ModConfigSpec.Builder builder, String name, boolean defaultValue, String comment) {
        return builder.comment(comment).translation(name).define(name, defaultValue);
    }

    private static ModConfigSpec.IntValue buildInteger(ModConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    private static ModConfigSpec.DoubleValue buildDouble(ModConfigSpec.Builder builder, String name, double defaultValue, double min, double max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    public static void bake(ModConfig config) {
        try {
            genderEuphoriaShader = (Boolean)DataNEssenceClientConfig.CLIENT.genderEuphoriaShaderValue.get();
            pingShader = (Boolean)DataNEssenceClientConfig.CLIENT.pingShaderValue.get();
            progressionShader = (Boolean)DataNEssenceClientConfig.CLIENT.progressionShaderValue.get();
            colorAssist = (Boolean)DataNEssenceClientConfig.CLIENT.colorAssistValue.get();
        }
        catch (Exception e) {
            DataNEssence.LOGGER.warn("[DATANESSENCE] Failed to load client config!");
            e.printStackTrace();
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(DataNEssenceClientConfig::new);
        CLIENT = (DataNEssenceClientConfig)specPair.getLeft();
        CLIENT_SPEC = (ModConfigSpec)specPair.getRight();
        genderEuphoriaShader = true;
        pingShader = true;
        progressionShader = true;
        colorAssist = false;
    }
}

