/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.entity;

import com.cmdpro.databank.misc.TrailRender;
import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.entity.EssenceSlashProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class EssenceSlashRenderer
extends EntityRenderer<EssenceSlashProjectile> {
    public EssenceSlashRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    public void render(EssenceSlashProjectile pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        List<TrailRender> trails = pEntity.getTrails();
        if (trails != null) {
            pPoseStack.pushPose();
            double d0 = Mth.lerp((double)pPartialTick, (double)pEntity.xOld, (double)pEntity.getX());
            double d1 = Mth.lerp((double)pPartialTick, (double)pEntity.yOld, (double)pEntity.getY());
            double d2 = Mth.lerp((double)pPartialTick, (double)pEntity.zOld, (double)pEntity.getZ());
            Vec3 posOffset = new Vec3(d0, d1, d2).subtract(pEntity.position());
            Vec3 pos = pEntity.position().add(posOffset);
            pPoseStack.translate(-pos.x, -pos.y, -pos.z);
            for (int i = 0; i < trails.size(); ++i) {
                TrailRender trail = pEntity.getTrail(i);
                Vec3 offset = pEntity.getTrailOffset(i);
                trail.position = pEntity.getBoundingBox().getCenter().add(posOffset).add(offset);
                trail.render(pPoseStack, (MultiBufferSource)RenderHandler.createBufferSource(), 0xF000F0, pEntity.getGradient());
            }
            pPoseStack.popPose();
        }
        super.render((Entity)pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.pushPose();
        pPoseStack.translate(0.0f, 0.5f, 0.0f);
        Vec2 rot = this.calculateRotationVector(new Vec3(0.0, 0.0, 0.0), pEntity.getDeltaMovement());
        pPoseStack.mulPose(Axis.YP.rotation((-rot.y - 90.0f) * ((float)Math.PI / 180)));
        pPoseStack.mulPose(Axis.ZP.rotation(-rot.x * ((float)Math.PI / 180)));
        pPoseStack.mulPose(Axis.XP.rotation((float)pEntity.rotation * ((float)Math.PI / 180)));
        PoseStack.Pose posestack$pose = pPoseStack.last();
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(pEntity)));
        EssenceSlashRenderer.vertex(vertexconsumer, posestack$pose, 0xF000F0, 0.0f, 0, 0, 1);
        EssenceSlashRenderer.vertex(vertexconsumer, posestack$pose, 0xF000F0, 1.0f, 0, 1, 1);
        EssenceSlashRenderer.vertex(vertexconsumer, posestack$pose, 0xF000F0, 1.0f, 1, 1, 0);
        EssenceSlashRenderer.vertex(vertexconsumer, posestack$pose, 0xF000F0, 0.0f, 1, 0, 0);
        pPoseStack.popPose();
    }

    private static void vertex(VertexConsumer pConsumer, PoseStack.Pose pPose, int pPackedLight, float pX, int pY, int pU, int pV) {
        pConsumer.addVertex(pPose, pX - 0.5f, (float)pY - 0.5f, 0.0f).setColor(255, 255, 255, 255).setUv((float)pU, (float)pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(pPackedLight).setNormal(pPose, 0.0f, 1.0f, 0.0f);
    }

    public Vec2 calculateRotationVector(Vec3 pVec, Vec3 pTarget) {
        double d0 = pTarget.x - pVec.x;
        double d1 = pTarget.y - pVec.y;
        double d2 = pTarget.z - pVec.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        return new Vec2(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875)))), Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f)));
    }

    public ResourceLocation getTextureLocation(EssenceSlashProjectile pEntity) {
        return DataNEssence.locate("textures/entity/essence_slash.png");
    }

    public boolean shouldRender(EssenceSlashProjectile livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }
}

