/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.block;

import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankModels;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityModel;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityRenderer;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.block.production.MetalShaper;
import com.cmdpro.datanessence.block.production.MetalShaperBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MetalShaperRenderer
extends DatabankBlockEntityRenderer<MetalShaperBlockEntity> {
    public MetalShaperRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        super((DatabankBlockEntityModel)new Model());
    }

    public void render(MetalShaperBlockEntity metalShaper, float pPartialTick, PoseStack poseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Direction facing = (Direction)metalShaper.getBlockState().getValue((Property)MetalShaper.FACING);
        Vec3 rotateAround = new Vec3(0.5, 0.5, 0.5);
        ItemStack item = metalShaper.getItemHandler().getStackInSlot(0);
        if (facing.equals((Object)Direction.NORTH)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(0.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.SOUTH)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(180.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.EAST)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(-90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.WEST)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.2, 0.5);
        poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
        poseStack.scale(0.5f, 0.5f, 0.5f);
        Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, poseStack, pBufferSource, metalShaper.getLevel(), 0);
        poseStack.popPose();
        super.render((BlockEntity)metalShaper, pPartialTick, poseStack, pBufferSource, pPackedLight, pPackedOverlay);
    }

    public static class Model
    extends DatabankBlockEntityModel<MetalShaperBlockEntity> {
        public DatabankModel model;

        public DatabankModel getModel() {
            if (this.model == null) {
                this.model = (DatabankModel)DatabankModels.models.get(DataNEssence.locate("metal_shaper"));
            }
            return this.model;
        }

        public void setupModelPose(MetalShaperBlockEntity pEntity, float partialTick) {
            pEntity.animState.updateAnimDefinitions(this.getModel());
            if (pEntity.workTime >= 0 && pEntity.workTime <= pEntity.maxWorkTime - 15) {
                pEntity.animState.setAnim("lower_press");
            } else {
                pEntity.animState.setAnim("raise_press");
            }
            this.animate(pEntity.animState);
        }

        public ResourceLocation getTextureLocation() {
            return DataNEssence.locate("textures/block/metal_shaper.png");
        }
    }
}

