/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.block;

import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankModels;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityModel;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityRenderer;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.block.processing.InfuserBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;

public class InfuserRenderer
extends DatabankBlockEntityRenderer<InfuserBlockEntity> {
    public InfuserRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        super((DatabankBlockEntityModel)new Model());
    }

    public void render(InfuserBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        super.render((BlockEntity)pBlockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 0.5, 0.5);
        pPoseStack.mulPose(Axis.YP.rotationDegrees((float)(pBlockEntity.getLevel().getLevelData().getGameTime() % 360L)));
        pPoseStack.scale(0.25f, 0.25f, 0.25f);
        Minecraft.getInstance().getItemRenderer().renderStatic(pBlockEntity.item, ItemDisplayContext.FIXED, pBlockEntity.workTime >= 0 ? 0xF000F0 : pPackedLight, pPackedOverlay, pPoseStack, pBufferSource, pBlockEntity.getLevel(), 0);
        pPoseStack.popPose();
    }

    public static class Model
    extends DatabankBlockEntityModel<InfuserBlockEntity> {
        public DatabankModel model;

        public DatabankModel getModel() {
            if (this.model == null) {
                this.model = (DatabankModel)DatabankModels.models.get(DataNEssence.locate("infuser"));
            }
            return this.model;
        }

        public ResourceLocation getTextureLocation() {
            return DataNEssence.locate("textures/block/infuser.png");
        }

        public void setupModelPose(InfuserBlockEntity pEntity, float partialTick) {
            pEntity.animState.updateAnimDefinitions(this.getModel());
            if (!pEntity.item.isEmpty()) {
                if (pEntity.workTime >= 0) {
                    pEntity.animState.setAnim("active");
                } else {
                    pEntity.animState.setAnim("idle");
                }
            } else {
                pEntity.animState.setAnim("deactivated");
            }
            this.animate(pEntity.animState);
        }
    }
}

