/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.block;

import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankModels;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityModel;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityRenderer;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.pearlnetwork.PearlNetworkBlockRenderHelper;
import com.cmdpro.datanessence.block.transportation.EnderPearlCapture;
import com.cmdpro.datanessence.block.transportation.EnderPearlCaptureBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EnderPearlCaptureRenderer
extends DatabankBlockEntityRenderer<EnderPearlCaptureBlockEntity>
implements PearlNetworkBlockRenderHelper {
    public EnderPearlCaptureRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        super((DatabankBlockEntityModel)new Model());
    }

    public void render(EnderPearlCaptureBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        pPoseStack.pushPose();
        Direction facing = (Direction)pBlockEntity.getBlockState().getValue((Property)EnderPearlCapture.FACING);
        this.rotateStack(facing, pPoseStack);
        super.render((BlockEntity)pBlockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
        pPoseStack.popPose();
        this.renderPearlConnections(pBlockEntity, pPoseStack);
    }

    public AABB getRenderBoundingBox(EnderPearlCaptureBlockEntity blockEntity) {
        return AABB.INFINITE;
    }

    public void rotateStack(Direction facing, PoseStack poseStack) {
        Vec3 rotateAround = new Vec3(0.5, 0.5, 0.5);
        if (facing.equals((Object)Direction.DOWN)) {
            poseStack.rotateAround(Axis.XP.rotationDegrees(180.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.NORTH)) {
            poseStack.rotateAround(Axis.XP.rotationDegrees(-90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.SOUTH)) {
            poseStack.rotateAround(Axis.XP.rotationDegrees(90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.EAST)) {
            poseStack.rotateAround(Axis.ZP.rotationDegrees(-90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.WEST)) {
            poseStack.rotateAround(Axis.ZP.rotationDegrees(90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
    }

    public static class Model
    extends DatabankBlockEntityModel<EnderPearlCaptureBlockEntity> {
        public DatabankModel model;

        public DatabankModel getModel() {
            if (this.model == null) {
                this.model = (DatabankModel)DatabankModels.models.get(DataNEssence.locate("ender_pearl_capture"));
            }
            return this.model;
        }

        public ResourceLocation getTextureLocation() {
            return DataNEssence.locate("textures/block/ender_pearl_capture.png");
        }

        public void setupModelPose(EnderPearlCaptureBlockEntity pEntity, float partialTick) {
            pEntity.animState.updateAnimDefinitions(this.getModel());
            this.animate(pEntity.animState);
        }
    }
}

