/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.block;

import com.cmdpro.datanessence.block.processing.DryingTableBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class DryingTableRenderer
implements BlockEntityRenderer<DryingTableBlockEntity> {
    EntityRenderDispatcher renderDispatcher;

    public DryingTableRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        this.renderDispatcher = rendererProvider.getEntityRenderer();
    }

    public void render(DryingTableBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack item;
        IClientFluidTypeExtensions fluidTypeExtensions;
        ResourceLocation stillTexture;
        FluidStack fluid = blockEntity.getFluidHandler().getFluidInTank(0);
        int max = blockEntity.getFluidHandler().getTankCapacity(0);
        float fill = (float)fluid.getAmount() / (float)max;
        if (fill > 0.0f && (stillTexture = (fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid())).getStillTexture(fluid)) != null) {
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
            int tintColor = fluidTypeExtensions.getTintColor(fluid);
            VertexConsumer builder = bufferSource.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)fluid.getFluid().defaultFluidState()));
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.scale(0.8f, 0.8f, 0.8f);
            float u0 = sprite.getU0();
            float u1 = sprite.getU1();
            float v0 = sprite.getV0();
            float v1 = sprite.getV1();
            DryingTableRenderer.renderQuad(builder, poseStack, -0.5f, -0.5f + fill, -0.5f, 0.5f, -0.5f + fill, 0.5f, u0, v0, u1, v1, packedLight, tintColor);
            poseStack.popPose();
        }
        if ((item = blockEntity.getItemHandler().getStackInSlot(0)) != ItemStack.EMPTY) {
            poseStack.pushPose();
            poseStack.translate(0.5, 0.85, 0.5);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            Minecraft.getInstance().getItemRenderer().renderStatic(item, ItemDisplayContext.FIXED, packedLight, packedOverlay, poseStack, bufferSource, blockEntity.getLevel(), 0);
            poseStack.popPose();
        }
    }

    private static void drawVertex(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int packedLight, int color) {
        builder.addVertex(poseStack.last().pose(), x, y, z).setColor(color).setUv(u, v).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
    }

    private static void renderQuad(VertexConsumer builder, PoseStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, int packedLight, int color) {
        DryingTableRenderer.drawVertex(builder, poseStack, x0, y0, z0, u0, v0, packedLight, color);
        DryingTableRenderer.drawVertex(builder, poseStack, x0, y1, z1, u0, v1, packedLight, color);
        DryingTableRenderer.drawVertex(builder, poseStack, x1, y1, z1, u1, v1, packedLight, color);
        DryingTableRenderer.drawVertex(builder, poseStack, x1, y0, z0, u1, v0, packedLight, color);
    }
}

