/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.renderers.block;

import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankModels;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityModel;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityRenderer;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.block.auxiliary.Charger;
import com.cmdpro.datanessence.block.auxiliary.ChargerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ChargerRenderer
extends DatabankBlockEntityRenderer<ChargerBlockEntity> {
    public ChargerRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        super((DatabankBlockEntityModel)new Model());
    }

    public void render(ChargerBlockEntity charger, float pPartialTick, PoseStack poseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        Direction facing = (Direction)charger.getBlockState().getValue((Property)Charger.FACING);
        Vec3 rotateAround = new Vec3(0.5, 0.5, 0.5);
        if (facing.equals((Object)Direction.NORTH)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(0.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.SOUTH)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(180.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.EAST)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(-90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (facing.equals((Object)Direction.WEST)) {
            poseStack.rotateAround(Axis.YP.rotationDegrees(90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        super.render((BlockEntity)charger, pPartialTick, poseStack, pBufferSource, pPackedLight, pPackedOverlay);
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)(charger.getLevel().getLevelData().getGameTime() % 360L)));
        poseStack.scale(0.25f, 0.25f, 0.25f);
        Minecraft.getInstance().getItemRenderer().renderStatic(charger.item, ItemDisplayContext.FIXED, pPackedLight, pPackedOverlay, poseStack, pBufferSource, charger.getLevel(), 0);
        poseStack.popPose();
    }

    public static class Model
    extends DatabankBlockEntityModel<ChargerBlockEntity> {
        public DatabankModel model;

        public ResourceLocation getTextureLocation() {
            return DataNEssence.locate("textures/block/charger.png");
        }

        public void setupModelPose(ChargerBlockEntity pEntity, float partialTick) {
            pEntity.animState.updateAnimDefinitions(this.getModel());
            DatabankAnimationState state = pEntity.animState;
            if (!pEntity.item.isEmpty()) {
                if (state.isCurrentAnim("idle_empty")) {
                    state.setAnim("extend_exciters");
                }
                if (pEntity.charging) {
                    if (state.isCurrentAnim("idle_exciters_out")) {
                        state.setAnim("orb_rise");
                    }
                } else if (state.isCurrentAnim("orb_spin") || state.isCurrentAnim("orb_rise")) {
                    state.setAnim("orb_fall");
                }
            } else if (state.isCurrentAnim("orb_spin") || state.isCurrentAnim("orb_rise")) {
                state.setAnim("orb_fall");
            } else if (state.isCurrentAnim("idle_exciters_out") || (state.isCurrentAnim("extend_exciters") || state.isCurrentAnim("orb_fall")) && state.isDone()) {
                state.setAnim("retract_exciters");
            }
            this.animate(pEntity.animState);
        }

        public DatabankModel getModel() {
            if (this.model == null) {
                this.model = (DatabankModel)DatabankModels.models.get(DataNEssence.locate("charger"));
            }
            return this.model;
        }
    }
}

