/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.particle;

import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.databank.rendering.RenderTypeHandler;
import com.cmdpro.datanessence.client.particle.CircleParticle;
import com.cmdpro.datanessence.client.particle.MoteParticleOptions;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class MoteParticle
extends TextureSheetParticle {
    public float maxQuadSize;
    public MoteParticleOptions options;

    protected MoteParticle(ClientLevel level, double xCoord, double yCoord, double zCoord, SpriteSet spriteSet, double xd, double yd, double zd, MoteParticleOptions options) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.quadSize *= 0.85f;
        this.maxQuadSize = this.quadSize;
        this.setSpriteFromAge(spriteSet);
        this.rCol = (float)options.color.getRed() / 255.0f;
        this.gCol = (float)options.color.getGreen() / 255.0f;
        this.bCol = (float)options.color.getBlue() / 255.0f;
        this.alpha = (float)options.color.getAlpha() / 255.0f;
        this.friction = options.friction;
        this.lifetime = options.lifetime;
        this.gravity = options.gravity;
        this.hasPhysics = options.physics;
        this.options = options;
    }

    public void render(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        super.render(RenderHandler.createBufferSource().getBuffer(this.options.additive ? RenderTypeHandler.ADDITIVE_PARTICLE : RenderTypeHandler.TRANSPARENT_PARTICLE), pRenderInfo, pPartialTicks);
    }

    protected int getLightColor(float partialTick) {
        if (this.options.fullbright) {
            return 0xF000F0;
        }
        return super.getLightColor(partialTick);
    }

    public ParticleRenderType getRenderType() {
        return this.options.additive ? CircleParticle.ADDITIVE : ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.fadeOut();
    }

    private void fadeOut() {
        this.quadSize = (-(1.0f / (float)this.lifetime) * (float)this.age + 1.0f) * this.maxQuadSize;
    }

    public static class Provider
    implements ParticleProvider<MoteParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(MoteParticleOptions particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new MoteParticle(level, x, y, z, this.sprites, dx, dy, dz, particleType);
        }
    }
}

