/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;

public abstract class ConfigurableParticleOptions
implements ParticleOptions {
    public Color color = Color.WHITE;
    public boolean additive = false;
    public int lifetime = 20;
    public float friction = 0.8f;
    public float gravity = 0.0f;
    public boolean physics = false;
    public boolean fullbright = false;

    public ConfigurableParticleOptions setColor(Color color) {
        this.color = color;
        return this;
    }

    public ConfigurableParticleOptions setAdditive(boolean additive) {
        this.additive = additive;
        return this;
    }

    public ConfigurableParticleOptions setLifetime(int lifetime) {
        this.lifetime = lifetime;
        return this;
    }

    public ConfigurableParticleOptions setFriction(float friction) {
        this.friction = friction;
        return this;
    }

    public ConfigurableParticleOptions setGravity(float gravity) {
        this.gravity = gravity;
        return this;
    }

    public ConfigurableParticleOptions setPhysics(boolean physics) {
        this.physics = physics;
        return this;
    }

    public ConfigurableParticleOptions setFullbright(boolean fullbright) {
        this.fullbright = fullbright;
        return this;
    }

    public static <T extends ConfigurableParticleOptions> MapCodec<T> createCodec(Supplier<T> createInstance) {
        MapCodec codec = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ExtraCodecs.ARGB_COLOR_CODEC.fieldOf("color").forGetter(particle -> particle.color.getRGB()), (App)Codec.BOOL.fieldOf("additive").forGetter(particle -> particle.additive), (App)Codec.INT.fieldOf("lifetime").forGetter(particle -> particle.lifetime), (App)Codec.FLOAT.fieldOf("friction").forGetter(particle -> Float.valueOf(particle.friction)), (App)Codec.FLOAT.fieldOf("gravity").forGetter(particle -> Float.valueOf(particle.gravity)), (App)Codec.BOOL.fieldOf("physics").forGetter(particle -> particle.physics), (App)Codec.BOOL.fieldOf("fullbright").forGetter(particle -> particle.fullbright)).apply((Applicative)builder, (arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ConfigurableParticleOptions.lambda$createCodec$7((Supplier)createInstance, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6)));
        return codec;
    }

    public static <T extends ConfigurableParticleOptions> StreamCodec<RegistryFriendlyByteBuf, T> createStreamCodec(Supplier<T> createInstance) {
        StreamCodec codec = StreamCodec.of((buf, options) -> {
            buf.writeInt(options.color.getRGB());
            buf.writeBoolean(options.additive);
            buf.writeInt(options.lifetime);
            buf.writeFloat(options.friction);
            buf.writeFloat(options.gravity);
            buf.writeBoolean(options.physics);
            buf.writeBoolean(options.fullbright);
        }, buf -> {
            int rgb = buf.readInt();
            boolean additive = buf.readBoolean();
            int lifetime = buf.readInt();
            float friction = buf.readFloat();
            float gravity = buf.readFloat();
            boolean physics = buf.readBoolean();
            boolean fullbright = buf.readBoolean();
            return ((ConfigurableParticleOptions)createInstance.get()).setColor(new Color(rgb)).setAdditive(additive).setLifetime(lifetime).setFriction(friction).setGravity(gravity).setPhysics(physics).setFullbright(fullbright);
        });
        return codec;
    }

    private static /* synthetic */ ConfigurableParticleOptions lambda$createCodec$7(Supplier createInstance, Integer color, Boolean additive, Integer lifetime, Float friction, Float gravity, Boolean physics, Boolean fullbright) {
        return ((ConfigurableParticleOptions)createInstance.get()).setColor(new Color(color)).setAdditive(additive).setLifetime(lifetime).setFriction(friction.floatValue()).setGravity(gravity.floatValue()).setPhysics(physics).setFullbright(fullbright);
    }
}

