/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client.particle;

import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.databank.rendering.RenderTypeHandler;
import com.cmdpro.datanessence.client.particle.CircleParticleOptions;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;

public class CircleParticle
extends TextureSheetParticle {
    public float startQuadSize;
    public CircleParticleOptions options;
    public static final ParticleRenderType ADDITIVE = new ParticleRenderType(){

        @Nullable
        public BufferBuilder begin(Tesselator pBuilder, TextureManager pTextureManager) {
            Minecraft.getInstance().gameRenderer.lightTexture().turnOnLightLayer();
            RenderSystem.enableBlend();
            RenderSystem.enableCull();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.blendFunc((int)GlStateManager.SourceFactor.SRC_ALPHA.value, (int)GlStateManager.DestFactor.ONE.value);
            return pBuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
        }

        public String toString() {
            return "datanessence:additive";
        }
    };

    protected CircleParticle(ClientLevel level, double xCoord, double yCoord, double zCoord, SpriteSet spriteSet, double xd, double yd, double zd, CircleParticleOptions options) {
        super(level, xCoord, yCoord, zCoord, xd, yd, zd);
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
        this.quadSize *= 0.85f;
        this.startQuadSize = this.quadSize;
        this.setSpriteFromAge(spriteSet);
        this.rCol = (float)options.color.getRed() / 255.0f;
        this.gCol = (float)options.color.getGreen() / 255.0f;
        this.bCol = (float)options.color.getBlue() / 255.0f;
        this.alpha = (float)options.color.getAlpha() / 255.0f;
        this.friction = options.friction;
        this.lifetime = options.lifetime;
        this.gravity = options.gravity;
        this.hasPhysics = options.physics;
        this.options = options;
    }

    protected int getLightColor(float partialTick) {
        if (this.options.fullbright) {
            return 0xF000F0;
        }
        return super.getLightColor(partialTick);
    }

    public void tick() {
        super.tick();
        this.fadeOut();
    }

    public void render(VertexConsumer pBuffer, Camera pRenderInfo, float pPartialTicks) {
        super.render(RenderHandler.createBufferSource().getBuffer(this.options.additive ? RenderTypeHandler.ADDITIVE_PARTICLE : RenderTypeHandler.TRANSPARENT_PARTICLE), pRenderInfo, pPartialTicks);
    }

    public ParticleRenderType getRenderType() {
        return this.options.additive ? ADDITIVE : ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    private void fadeOut() {
        this.quadSize = (-(1.0f / (float)this.lifetime) * (float)this.age + 1.0f) * this.startQuadSize;
    }

    public static class Provider
    implements ParticleProvider<CircleParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(CircleParticleOptions particleType, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new CircleParticle(level, x, y, z, this.sprites, dx, dy, dz, particleType);
        }
    }
}

