/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client;

import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.datamaps.DataNEssenceDatamaps;
import com.cmdpro.datanessence.datamaps.PlantSiphonEssenceMap;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.screen.IndustrialPlantSiphonScreen;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="datanessence")
public class SpecialTooltips {
    public static final Function<ItemTooltipEvent, Boolean> PLANT_SIPHON_CONDITION = event -> event.getItemStack().getItemHolder().getData(DataNEssenceDatamaps.PLANT_SIPHON_ESSENCE) != null && Minecraft.getInstance().screen instanceof IndustrialPlantSiphonScreen;
    private static final HashMap<Function<ItemTooltipEvent, Boolean>, Consumer<ItemTooltipEvent>> TOOLTIPS = new HashMap();

    @SubscribeEvent
    public static void onTooltipEvent(ItemTooltipEvent event) {
        for (Map.Entry<Function<ItemTooltipEvent, Boolean>, Consumer<ItemTooltipEvent>> i : TOOLTIPS.entrySet()) {
            if (!i.getKey().apply(event).booleanValue()) continue;
            i.getValue().accept(event);
        }
    }

    static {
        TOOLTIPS.put(PLANT_SIPHON_CONDITION, event -> {
            PlantSiphonEssenceMap map = (PlantSiphonEssenceMap)event.getItemStack().getItemHolder().getData(DataNEssenceDatamaps.PLANT_SIPHON_ESSENCE);
            if (map != null) {
                EssenceType essence = EssenceTypeRegistry.ESSENCE.get();
                Color color = new Color(essence.color);
                Color essenceColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                Color numberColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
                Color textColor = new Color(-26955);
                DecimalFormat format = new DecimalFormat("#.##");
                event.getToolTip().add(Component.translatable((String)"tooltip.datanessence.plant_siphon_display.text").withStyle(ChatFormatting.ITALIC).withColor(-893279));
                event.getToolTip().add(Component.translatable((String)"tooltip.datanessence.plant_siphon_display.values", (Object[])new Object[]{Component.literal((String)format.format(map.amountPerTick())).withColor(numberColor.getRGB()), Component.literal((String)String.valueOf(map.ticks())).withColor(numberColor.getRGB()), essence.name.copy().withColor(essenceColor.getRGB())}).withColor(textColor.getRGB()));
            }
        });
    }
}

