/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client;

import com.cmdpro.databank.rendering.ColorUtil;
import com.cmdpro.databank.shaders.PostShaderInstance;
import com.cmdpro.databank.shaders.PostShaderManager;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.item.ItemDecorators;
import com.cmdpro.datanessence.api.item.ItemEssenceContainer;
import com.cmdpro.datanessence.api.util.client.AnimatedBlockItemUtil;
import com.cmdpro.datanessence.client.gui.PingsGuiLayer;
import com.cmdpro.datanessence.client.particle.CircleParticle;
import com.cmdpro.datanessence.client.particle.EssenceSparkleParticle;
import com.cmdpro.datanessence.client.particle.MoteParticle;
import com.cmdpro.datanessence.client.particle.RhombusParticle;
import com.cmdpro.datanessence.client.particle.SmallCircleParticle;
import com.cmdpro.datanessence.client.renderers.block.ArekkoRenderer;
import com.cmdpro.datanessence.client.renderers.block.AutoFabricatorRenderer;
import com.cmdpro.datanessence.client.renderers.block.ChargerRenderer;
import com.cmdpro.datanessence.client.renderers.block.CryochamberRenderer;
import com.cmdpro.datanessence.client.renderers.block.DryingTableRenderer;
import com.cmdpro.datanessence.client.renderers.block.EnderPearlCaptureRenderer;
import com.cmdpro.datanessence.client.renderers.block.EnderPearlDestinationRenderer;
import com.cmdpro.datanessence.client.renderers.block.EnderPearlRelayRenderer;
import com.cmdpro.datanessence.client.renderers.block.EnticingLureRenderer;
import com.cmdpro.datanessence.client.renderers.block.EntropicProcessorRenderer;
import com.cmdpro.datanessence.client.renderers.block.EssenceBatteryRenderer;
import com.cmdpro.datanessence.client.renderers.block.EssenceBridgeRenderer;
import com.cmdpro.datanessence.client.renderers.block.EssencePointRenderer;
import com.cmdpro.datanessence.client.renderers.block.ExoticEssencePointRenderer;
import com.cmdpro.datanessence.client.renderers.block.FabricatorRenderer;
import com.cmdpro.datanessence.client.renderers.block.FluidMixerRenderer;
import com.cmdpro.datanessence.client.renderers.block.FluidPointRenderer;
import com.cmdpro.datanessence.client.renderers.block.FluidTankRenderer;
import com.cmdpro.datanessence.client.renderers.block.IndustrialPlantSiphonRenderer;
import com.cmdpro.datanessence.client.renderers.block.InfuserRenderer;
import com.cmdpro.datanessence.client.renderers.block.ItemPointRenderer;
import com.cmdpro.datanessence.client.renderers.block.LaserEmitterRenderer;
import com.cmdpro.datanessence.client.renderers.block.LunarEssencePointRenderer;
import com.cmdpro.datanessence.client.renderers.block.MetalShaperRenderer;
import com.cmdpro.datanessence.client.renderers.block.NaturalEssencePointRenderer;
import com.cmdpro.datanessence.client.renderers.block.StructureProtectorRenderer;
import com.cmdpro.datanessence.client.renderers.entity.AncientSentinelRenderer;
import com.cmdpro.datanessence.client.renderers.entity.EmptyEntityRenderer;
import com.cmdpro.datanessence.client.renderers.entity.EssenceSlashRenderer;
import com.cmdpro.datanessence.client.renderers.entity.ThrownTrailItemRenderer;
import com.cmdpro.datanessence.client.renderers.layer.HornsLayer;
import com.cmdpro.datanessence.client.renderers.layer.TailLayer;
import com.cmdpro.datanessence.client.renderers.layer.WingsLayer;
import com.cmdpro.datanessence.client.shaders.GenderEuphoriaShader;
import com.cmdpro.datanessence.client.shaders.MachineOutputShader;
import com.cmdpro.datanessence.client.shaders.OrePingShader;
import com.cmdpro.datanessence.client.shaders.ProgressionShader;
import com.cmdpro.datanessence.integration.DataNEssenceIntegration;
import com.cmdpro.datanessence.integration.mekanism.ChemicalNodeRenderer;
import com.cmdpro.datanessence.item.equipment.GrapplingHook;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.BlockRegistry;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.EntityRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import com.cmdpro.datanessence.registry.MenuRegistry;
import com.cmdpro.datanessence.registry.ParticleRegistry;
import com.cmdpro.datanessence.screen.AutoFabricatorScreen;
import com.cmdpro.datanessence.screen.ChargerScreen;
import com.cmdpro.datanessence.screen.DryingTableScreen;
import com.cmdpro.datanessence.screen.EnticingLureScreen;
import com.cmdpro.datanessence.screen.EntropicProcessorScreen;
import com.cmdpro.datanessence.screen.EssenceBurnerScreen;
import com.cmdpro.datanessence.screen.EssenceFurnaceScreen;
import com.cmdpro.datanessence.screen.FabricatorScreen;
import com.cmdpro.datanessence.screen.FilterNodeUpgradeScreen;
import com.cmdpro.datanessence.screen.FluidBottlerScreen;
import com.cmdpro.datanessence.screen.FluidMixerScreen;
import com.cmdpro.datanessence.screen.IndustrialPlantSiphonScreen;
import com.cmdpro.datanessence.screen.InfuserScreen;
import com.cmdpro.datanessence.screen.ItemFilterScreen;
import com.cmdpro.datanessence.screen.LaserEmitterScreen;
import com.cmdpro.datanessence.screen.MelterScreen;
import com.cmdpro.datanessence.screen.MetalShaperScreen;
import com.cmdpro.datanessence.screen.MineralPurificationChamberScreen;
import com.cmdpro.datanessence.screen.MusicDiscPlayerScreen;
import com.cmdpro.datanessence.screen.SynthesisChamberScreen;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.joml.SimplexNoise;

@EventBusSubscriber(value={Dist.CLIENT}, modid="datanessence", bus=EventBusSubscriber.Bus.MOD)
public class ClientModEvents {
    public static PostShaderInstance progressionShader;
    public static PostShaderInstance genderEuphoriaShader;
    public static PostShaderInstance machineOutputShader;
    public static PostShaderInstance orePingShader;
    public static final ItemPropertyFunction usingGrapplingHookProperty;
    public static final ItemPropertyFunction chargedGrapplingHookProperty;

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(DataNEssence.locate("pings"), (LayeredDraw.Layer)new PingsGuiLayer());
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(BlockEntityRegistry.FABRICATOR.get(), FabricatorRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.ESSENCE_POINT.get(), EssencePointRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.LUNAR_ESSENCE_POINT.get(), LunarEssencePointRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.NATURAL_ESSENCE_POINT.get(), NaturalEssencePointRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.EXOTIC_ESSENCE_POINT.get(), ExoticEssencePointRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.ITEM_POINT.get(), ItemPointRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.FLUID_POINT.get(), FluidPointRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.INFUSER.get(), InfuserRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.CHARGER.get(), ChargerRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.LASER_EMITTER.get(), LaserEmitterRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.AUTO_FABRICATOR.get(), AutoFabricatorRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.FLUID_TANK.get(), FluidTankRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.ESSENCE_BATTERY.get(), EssenceBatteryRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.ENTROPIC_PROCESSOR.get(), EntropicProcessorRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.FLUID_MIXER.get(), FluidMixerRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.AREKKO.get(), ArekkoRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.ENTICING_LURE.get(), EnticingLureRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.METAL_SHAPER.get(), MetalShaperRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.INDUSTRIAL_PLANT_SIPHON.get(), IndustrialPlantSiphonRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.CRYOCHAMBER.get(), CryochamberRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.CHEMICAL_NODE.get(), ChemicalNodeRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.DRYING_TABLE.get(), DryingTableRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.ESSENCE_BRIDGE.get(), EssenceBridgeRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.ENDER_PEARL_CAPTURE.get(), EnderPearlCaptureRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.ENDER_PEARL_RELAY.get(), EnderPearlRelayRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.ENDER_PEARL_DESTINATION.get(), EnderPearlDestinationRenderer::new);
        event.registerBlockEntityRenderer(BlockEntityRegistry.STRUCTURE_PROTECTOR.get(), StructureProtectorRenderer::new);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        for (PlayerSkin.Model i : event.getSkins()) {
            LivingEntityRenderer skin = (LivingEntityRenderer)event.getSkin(i);
            skin.addLayer(new WingsLayer(skin, event.getEntityModels()));
            skin.addLayer(new HornsLayer(skin, event.getEntityModels()));
            skin.addLayer(new TailLayer(skin, event.getEntityModels()));
        }
    }

    @SubscribeEvent
    public static void doSetup(FMLClientSetupEvent event) {
        EntityRenderers.register(EntityRegistry.ESSENCE_BOMB.get(), ThrownTrailItemRenderer::new);
        EntityRenderers.register(EntityRegistry.LUNAR_ESSENCE_BOMB.get(), ThrownTrailItemRenderer::new);
        EntityRenderers.register(EntityRegistry.NATURAL_ESSENCE_BOMB.get(), ThrownTrailItemRenderer::new);
        EntityRenderers.register(EntityRegistry.EXOTIC_ESSENCE_BOMB.get(), ThrownTrailItemRenderer::new);
        EntityRenderers.register(EntityRegistry.BLACK_HOLE.get(), EmptyEntityRenderer::new);
        EntityRenderers.register(EntityRegistry.ANCIENT_SENTINEL.get(), AncientSentinelRenderer::new);
        EntityRenderers.register(EntityRegistry.ANCIENT_SENTINEL_PROJECTILE.get(), EmptyEntityRenderer::new);
        EntityRenderers.register(EntityRegistry.ESSENCE_SLASH_PROJECTILE.get(), EssenceSlashRenderer::new);
        event.enqueueWork(() -> {
            ItemProperties.register((Item)ItemRegistry.MUSIC_DISC_PLAYER.get(), (ResourceLocation)DataNEssence.locate("playing"), (stack, level, entity, seed) -> {
                if (stack.has(DataComponentRegistry.PLAYING_MUSIC)) {
                    return 1.0f;
                }
                return 0.0f;
            });
            ItemProperties.register((Item)ItemRegistry.GRAPPLING_HOOK.get(), (ResourceLocation)DataNEssence.locate("charged"), (ItemPropertyFunction)chargedGrapplingHookProperty);
            ItemProperties.register((Item)ItemRegistry.GRAPPLING_HOOK.get(), (ResourceLocation)DataNEssence.locate("using"), (ItemPropertyFunction)usingGrapplingHookProperty);
            ItemProperties.register((Item)ItemRegistry.TRANS_GRAPPLING_HOOK.get(), (ResourceLocation)DataNEssence.locate("charged"), (ItemPropertyFunction)chargedGrapplingHookProperty);
            ItemProperties.register((Item)ItemRegistry.TRANS_GRAPPLING_HOOK.get(), (ResourceLocation)DataNEssence.locate("using"), (ItemPropertyFunction)usingGrapplingHookProperty);
        });
        progressionShader = new ProgressionShader();
        PostShaderManager.addShader((PostShaderInstance)progressionShader);
        genderEuphoriaShader = new GenderEuphoriaShader();
        PostShaderManager.addShader((PostShaderInstance)genderEuphoriaShader);
        machineOutputShader = new MachineOutputShader();
        PostShaderManager.addShader((PostShaderInstance)machineOutputShader);
        machineOutputShader.setActive(true);
        orePingShader = new OrePingShader();
        PostShaderManager.addShader((PostShaderInstance)orePingShader);
        orePingShader.setActive(true);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/auto-fabricator.png"), DataNEssence.locate("auto-fabricator")), new Item[]{BlockRegistry.AUTO_FABRICATOR.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/charger.png"), DataNEssence.locate("charger")), new Item[]{BlockRegistry.CHARGER.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/entropic_processor.png"), DataNEssence.locate("entropic_processor")), new Item[]{BlockRegistry.ENTROPIC_PROCESSOR.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/essence_point.png"), DataNEssence.locate("essence_point")), new Item[]{BlockRegistry.ESSENCE_POINT.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/exotic_essence_point.png"), DataNEssence.locate("essence_point")), new Item[]{BlockRegistry.EXOTIC_ESSENCE_POINT.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/fabricator.png"), DataNEssence.locate("fabricator")), new Item[]{BlockRegistry.FABRICATOR.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/fluid_point.png"), DataNEssence.locate("essence_point")), new Item[]{BlockRegistry.FLUID_POINT.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/infuser.png"), DataNEssence.locate("infuser")), new Item[]{BlockRegistry.INFUSER.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/item_point.png"), DataNEssence.locate("essence_point")), new Item[]{BlockRegistry.ITEM_POINT.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/lunar_essence_point.png"), DataNEssence.locate("essence_point")), new Item[]{BlockRegistry.LUNAR_ESSENCE_POINT.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/natural_essence_point.png"), DataNEssence.locate("essence_point")), new Item[]{BlockRegistry.NATURAL_ESSENCE_POINT.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/fluid_mixer.png"), DataNEssence.locate("fluid_mixer")), new Item[]{BlockRegistry.FLUID_MIXER.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/metal_shaper.png"), DataNEssence.locate("metal_shaper")), new Item[]{BlockRegistry.METAL_SHAPER.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/industrial_plant_siphon.png"), DataNEssence.locate("industrial_plant_siphon")), new Item[]{BlockRegistry.INDUSTRIAL_PLANT_SIPHON.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/chemical_node.png"), DataNEssence.locate("essence_point")), new Item[]{BlockRegistry.CHEMICAL_NODE.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/ender_pearl_capture.png"), DataNEssence.locate("ender_pearl_capture")), new Item[]{BlockRegistry.ENDER_PEARL_CAPTURE.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/ender_pearl_relay.png"), DataNEssence.locate("ender_pearl_relay")), new Item[]{BlockRegistry.ENDER_PEARL_RELAY.get().asItem()});
        event.registerItem(AnimatedBlockItemUtil.createBasicExtensions(DataNEssence.locate("textures/block/ender_pearl_destination.png"), DataNEssence.locate("ender_pearl_destination")), new Item[]{BlockRegistry.ENDER_PEARL_DESTINATION.get().asItem()});
    }

    @SubscribeEvent
    public static void registerItemDecorations(RegisterItemDecorationsEvent event) {
        event.register((ItemLike)ItemRegistry.ESSENCE_SWORD.get(), ItemDecorators.essenceBarDecoration);
        event.register((ItemLike)ItemRegistry.ILLUMINATION_ROD.get(), ItemDecorators.essenceBarDecoration);
        event.register((ItemLike)ItemRegistry.PRIMITIVE_ANTI_GRAVITY_PACK.get(), ItemDecorators.essenceBarDecoration);
        event.register((ItemLike)ItemRegistry.GRAPPLING_HOOK.get(), ItemDecorators.essenceBarDecoration);
        event.register((ItemLike)ItemRegistry.TRANS_GRAPPLING_HOOK.get(), ItemDecorators.essenceBarDecoration);
        event.register((ItemLike)ItemRegistry.ORE_SCANNER.get(), ItemDecorators.essenceBarDecoration);
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register(MenuRegistry.FABRICATOR_MENU.get(), FabricatorScreen::new);
        event.register(MenuRegistry.ESSENCE_BURNER_MENU.get(), EssenceBurnerScreen::new);
        event.register(MenuRegistry.INFUSER_MENU.get(), InfuserScreen::new);
        event.register(MenuRegistry.CHARGER_MENU.get(), ChargerScreen::new);
        event.register(MenuRegistry.LASER_EMITTER_MENU.get(), LaserEmitterScreen::new);
        event.register(MenuRegistry.AUTO_FABRICATOR_MENU.get(), AutoFabricatorScreen::new);
        event.register(MenuRegistry.FLUID_BOTTLER_MENU.get(), FluidBottlerScreen::new);
        event.register(MenuRegistry.ENTROPIC_PROCESSOR_MENU.get(), EntropicProcessorScreen::new);
        event.register(MenuRegistry.ESSENCE_FURNACE_MENU.get(), EssenceFurnaceScreen::new);
        event.register(MenuRegistry.SYNTHESIS_CHAMBER_MENU.get(), SynthesisChamberScreen::new);
        event.register(MenuRegistry.FLUID_MIXER_MENU.get(), FluidMixerScreen::new);
        event.register(MenuRegistry.ENTICING_LURE_MENU.get(), EnticingLureScreen::new);
        event.register(MenuRegistry.MINERAL_PURIFICATION_CHAMBER_MENU.get(), MineralPurificationChamberScreen::new);
        event.register(MenuRegistry.ITEM_FILTER_MENU.get(), ItemFilterScreen::new);
        event.register(MenuRegistry.MUSIC_DISC_PLAYER_MENU.get(), MusicDiscPlayerScreen::new);
        event.register(MenuRegistry.FILTER_NODE_UPGRADE_MENU.get(), FilterNodeUpgradeScreen::new);
        event.register(MenuRegistry.METAL_SHAPER_MENU.get(), MetalShaperScreen::new);
        event.register(MenuRegistry.INDUSTRIAL_PLANT_SIPHON_MENU.get(), IndustrialPlantSiphonScreen::new);
        event.register(MenuRegistry.MELTER_MENU.get(), MelterScreen::new);
        event.register(MenuRegistry.DRYING_TABLE_MENU.get(), DryingTableScreen::new);
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft.getInstance().particleEngine.register((ParticleType)ParticleRegistry.ESSENCE_SPARKLE.get(), EssenceSparkleParticle.Provider::new);
        Minecraft.getInstance().particleEngine.register(ParticleRegistry.CIRCLE.get(), CircleParticle.Provider::new);
        Minecraft.getInstance().particleEngine.register(ParticleRegistry.RHOMBUS.get(), RhombusParticle.Provider::new);
        Minecraft.getInstance().particleEngine.register(ParticleRegistry.SMALL_CIRCLE.get(), SmallCircleParticle.Provider::new);
        Minecraft.getInstance().particleEngine.register(ParticleRegistry.MOTE.get(), MoteParticle.Provider::new);
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((pState, pLevel, pPos, pTintIndex) -> {
            if (pPos != null) {
                return ColorUtil.blendColors((Color)new Color(832511), (Color)new Color(16730561), (float)((SimplexNoise.noise((float)((float)pPos.getX() / 25.0f), (float)((float)pPos.getY() / 25.0f), (float)((float)pPos.getZ() / 25.0f)) + 1.0f) / 2.0f)).getRGB();
            }
            float blendAmount = (float)Minecraft.getInstance().levelRenderer.getTicks() + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
            return ColorUtil.blendColors((Color)new Color(832511), (Color)new Color(16730561), (float)((float)(Math.sin(blendAmount / 72.0f) + 1.0) / 2.0f)).getRGB();
        }, new Block[]{BlockRegistry.SPIRE_GLASS.get()});
        event.register((pState, pLevel, pPos, pTintIndex) -> {
            if (pPos != null) {
                double x = pPos.getX();
                double y = pPos.getY();
                double z = pPos.getZ();
                float hue = (float)(y / 14.0 + (z / 42.0 + 0.5 + 0.5 * Math.sin(x / 14.0)));
                return Color.getHSBColor(hue, 0.8f, 1.0f).getRGB();
            }
            float blendAmount = (float)Minecraft.getInstance().levelRenderer.getTicks() + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
            return Color.getHSBColor((float)(Math.sin(blendAmount / 72.0f) + 1.0) / 2.0f, 0.8f, 1.0f).getRGB();
        }, new Block[]{BlockRegistry.CRYSTALLINE_LEAVES.get()});
        if (DataNEssenceIntegration.hasOpalescence) {
            event.register((pState, pLevel, pPos, pTintIndex) -> {
                if (pPos != null && pTintIndex == 0) {
                    return DataNEssenceIntegration.OpalescenseIntegration.getOpalBlockColor(pState, pLevel, pPos, pTintIndex);
                }
                return -1;
            }, new Block[]{BlockRegistry.TRAVERSITE_ROAD_OPAL.get(), BlockRegistry.TRAVERSITE_ROAD_SLAB_OPAL.get(), BlockRegistry.TRAVERSITE_ROAD_STAIRS_OPAL.get()});
        }
    }

    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((pStack, pTintIndex) -> {
            float blendAmount = (float)Minecraft.getInstance().levelRenderer.getTicks() + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
            return ColorUtil.blendColors((Color)new Color(832511), (Color)new Color(16730561), (float)((float)(Math.sin(blendAmount / 72.0f) + 1.0) / 2.0f)).getRGB();
        }, new ItemLike[]{(ItemLike)BlockRegistry.SPIRE_GLASS.get()});
        event.register((pStack, pTintIndex) -> {
            float blendAmount = (float)Minecraft.getInstance().levelRenderer.getTicks() + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks();
            return Color.getHSBColor((float)(Math.sin(blendAmount / 72.0f) + 1.0) / 2.0f, 1.0f, 1.0f).getRGB();
        }, new ItemLike[]{(ItemLike)BlockRegistry.CRYSTALLINE_LEAVES.get()});
        if (DataNEssenceIntegration.hasOpalescence) {
            event.register((stack, tintIndex) -> tintIndex == 0 ? DataNEssenceIntegration.OpalescenseIntegration.getOpalItemColor(stack, tintIndex) : -1, new ItemLike[]{(ItemLike)BlockRegistry.TRAVERSITE_ROAD_OPAL.get(), (ItemLike)BlockRegistry.TRAVERSITE_ROAD_SLAB_OPAL.get(), (ItemLike)BlockRegistry.TRAVERSITE_ROAD_STAIRS_OPAL.get()});
        }
    }

    static {
        usingGrapplingHookProperty = (stack, level, entity, seed) -> {
            if (entity != null && ((Optional)entity.getData(AttachmentTypeRegistry.GRAPPLING_HOOK_DATA)).isPresent()) {
                return 1.0f;
            }
            return 0.0f;
        };
        chargedGrapplingHookProperty = (stack, level, entity, seed) -> {
            if (stack.has(DataComponentRegistry.ESSENCE_STORAGE) && ItemEssenceContainer.getEssence(stack, GrapplingHook.FUEL_ESSENCE_TYPE) >= GrapplingHook.ESSENCE_COST) {
                return 1.0f;
            }
            return 0.0f;
        };
    }
}

