/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.client;

import com.cmdpro.databank.misc.RenderingUtil;
import com.cmdpro.databank.rendering.ColorUtil;
import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.databank.rendering.RenderProjectionUtil;
import com.cmdpro.databank.rendering.ShaderHelper;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.api.item.ItemEssenceContainer;
import com.cmdpro.datanessence.api.pearlnetwork.PearlNetworkBlockEntity;
import com.cmdpro.datanessence.api.util.client.ClientEssenceBarUtil;
import com.cmdpro.datanessence.api.util.client.ClientRenderingUtil;
import com.cmdpro.datanessence.client.ClientModEvents;
import com.cmdpro.datanessence.client.gui.PingsGuiLayer;
import com.cmdpro.datanessence.client.shaders.DataNEssenceCoreShaders;
import com.cmdpro.datanessence.client.shaders.DataNEssenceRenderTypes;
import com.cmdpro.datanessence.config.DataNEssenceClientConfig;
import com.cmdpro.datanessence.data.pinging.PingableStructure;
import com.cmdpro.datanessence.data.pinging.StructurePing;
import com.cmdpro.datanessence.entity.BlackHole;
import com.cmdpro.datanessence.item.equipment.EssenceMeter;
import com.cmdpro.datanessence.item.equipment.GrapplingHook;
import com.cmdpro.datanessence.moddata.ClientPlayerData;
import com.cmdpro.datanessence.networking.ModMessages;
import com.cmdpro.datanessence.networking.packet.c2s.RequestMachineEssenceValue;
import com.cmdpro.datanessence.networking.packet.s2c.AddScannedOre;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import com.cmdpro.datanessence.registry.MobEffectRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

@EventBusSubscriber(value={Dist.CLIENT}, modid="datanessence")
public class ClientEvents {
    public static RenderTarget tempRenderTarget;
    public static float time;
    public static SimpleSoundInstance musicDiscPlayerMusic;

    private static String format(float number) {
        DecimalFormat format = new DecimalFormat("#.0");
        Object num = format.format(number);
        if (((String)num).charAt(0) == '.') {
            num = "0" + (String)num;
        }
        return num;
    }

    @SubscribeEvent
    public static void itemTooltip(ItemTooltipEvent event) {
        float maxEssence = ItemEssenceContainer.getMaxEssence(event.getItemStack());
        for (ResourceLocation i : ItemEssenceContainer.getSupportedEssenceTypes(event.getItemStack())) {
            event.getToolTip().add(1, Component.translatable((String)((EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get((ResourceLocation)i)).tooltipKeyWithMax, (Object[])new Object[]{ClientEvents.format(ItemEssenceContainer.getEssence(event.getItemStack(), i)), ClientEvents.format(maxEssence)}));
        }
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (tempRenderTarget == null) {
            tempRenderTarget = new TextureTarget(mc.getMainRenderTarget().width, mc.getMainRenderTarget().height, true, Minecraft.ON_OSX);
        }
        float shaderTime = time + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true) / 20.0f;
        DataNEssenceCoreShaders.ESSENCE_BRIDGE.safeGetUniform("Time").set(shaderTime);
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_WEATHER)) {
            GrapplingHook hook;
            GrapplingHook.GrapplingHookData grapplingHookData;
            MultiBufferSource.BufferSource bufferSource = RenderHandler.createBufferSource();
            if (ClientPlayerData.getLinkPos() != null) {
                BlockEntity blockEntity = mc.level.getBlockEntity(ClientPlayerData.getLinkPos());
                Vec3 pos = event.getCamera().getPosition();
                Vec3 pos1 = ClientPlayerData.getLinkPos().getCenter();
                Vec3 pos2 = mc.player.getRopeHoldPosition(event.getPartialTick().getGameTimeDeltaPartialTick(true));
                Color color = ClientPlayerData.getLinkColor();
                event.getPoseStack().pushPose();
                event.getPoseStack().translate(-pos.x, -pos.y, -pos.z);
                if (blockEntity instanceof PearlNetworkBlockEntity) {
                    PearlNetworkBlockEntity ent = (PearlNetworkBlockEntity)blockEntity;
                    Vec3 currentPos = pos1;
                    Vec3 target = pos2;
                    VertexConsumer vertexConsumer = RenderHandler.createBufferSource().getBuffer(DataNEssenceRenderTypes.WIRES);
                    Vec3 normal = currentPos.subtract(target).normalize();
                    vertexConsumer.addVertex(event.getPoseStack().last(), (float)currentPos.x, (float)currentPos.y, (float)currentPos.z).setColor(color.getRGB()).setNormal(event.getPoseStack().last(), (float)normal.x, (float)normal.y, (float)normal.z);
                    currentPos = target;
                    vertexConsumer.addVertex(event.getPoseStack().last(), (float)currentPos.x, (float)currentPos.y, (float)currentPos.z).setColor(color.getRGB()).setNormal(event.getPoseStack().last(), (float)normal.x, (float)normal.y, (float)normal.z);
                } else {
                    ClientRenderingUtil.renderLine(bufferSource.getBuffer(DataNEssenceRenderTypes.WIRES), event.getPoseStack(), pos1, pos2, color);
                }
                event.getPoseStack().popPose();
            }
            for (Player i2 : mc.level.players()) {
                grapplingHookData = ((Optional)i2.getData(AttachmentTypeRegistry.GRAPPLING_HOOK_DATA)).orElse(null);
                if (grapplingHookData == null) continue;
                Vec3 pos = event.getCamera().getPosition();
                Vec3 pos1 = grapplingHookData.pos;
                Vec3 pos2 = i2.getRopeHoldPosition(event.getPartialTick().getGameTimeDeltaPartialTick(true));
                Color color = new Color(255, 255, 255);
                float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(true);
                Item item2 = i2.getMainHandItem().getItem();
                if (item2 instanceof GrapplingHook) {
                    GrapplingHook hook2 = (GrapplingHook)item2;
                    color = hook2.getHookColor(i2, i2.getMainHandItem(), partialTick);
                } else {
                    item2 = i2.getOffhandItem().getItem();
                    if (item2 instanceof GrapplingHook) {
                        hook = (GrapplingHook)item2;
                        color = hook.getHookColor(i2, i2.getOffhandItem(), partialTick);
                    }
                }
                event.getPoseStack().pushPose();
                event.getPoseStack().translate(-pos.x, -pos.y, -pos.z);
                ClientRenderingUtil.renderLine(bufferSource.getBuffer(DataNEssenceRenderTypes.WIRES), event.getPoseStack(), pos1, pos2, color, 0.05);
                event.getPoseStack().popPose();
            }
            if (mc.player != null) {
                HitResult gameTime2;
                HitResult hit;
                if (mc.player.isHolding(stack -> stack.getItem() instanceof GrapplingHook && ItemEssenceContainer.getEssence(stack, GrapplingHook.FUEL_ESSENCE_TYPE) >= 5.0f) && ((Optional)mc.player.getData(AttachmentTypeRegistry.GRAPPLING_HOOK_DATA)).isEmpty() && (hit = mc.player.pick(35.0, 0.0f, false)).getType() != HitResult.Type.MISS) {
                    long gameTime2 = mc.level.getGameTime();
                    float fade = (org.joml.Math.sin((float)(((float)gameTime2 + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks()) / 15.0f)) + 1.0f) / 2.0f;
                    Vec3 pos = event.getCamera().getPosition();
                    Vec3 pos1 = hit.getLocation();
                    Vec3 pos2 = mc.player.getRopeHoldPosition(event.getPartialTick().getGameTimeDeltaPartialTick(true));
                    event.getPoseStack().pushPose();
                    event.getPoseStack().translate(-pos.x, -pos.y, -pos.z);
                    Color color = Color.WHITE;
                    float partialTick = event.getPartialTick().getGameTimeDeltaPartialTick(true);
                    Item item3 = mc.player.getMainHandItem().getItem();
                    if (item3 instanceof GrapplingHook) {
                        hook = (GrapplingHook)item3;
                        color = hook.getHookColor((Player)mc.player, mc.player.getMainHandItem(), partialTick);
                    } else {
                        item3 = mc.player.getOffhandItem().getItem();
                        if (item3 instanceof GrapplingHook) {
                            GrapplingHook hook3 = (GrapplingHook)item3;
                            color = hook3.getHookColor((Player)mc.player, mc.player.getOffhandItem(), partialTick);
                        }
                    }
                    color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((0.5f - fade / 4.0f) * 255.0f));
                    ClientRenderingUtil.renderLine(bufferSource.getBuffer(DataNEssenceRenderTypes.WIRES), event.getPoseStack(), pos1, pos2, color, 0.05);
                    event.getPoseStack().popPose();
                }
                if ((gameTime2 = mc.hitResult) instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)gameTime2;
                    if (mc.player.isHolding(item -> item.getItem() instanceof EssenceMeter) && EssenceMeter.currentMachineEssenceValue != null && EssenceMeter.currentMachineEssenceValue.pos.equals((Object)blockHitResult.getBlockPos()) && (grapplingHookData = mc.level.getBlockEntity(blockHitResult.getBlockPos())) instanceof EssenceBlockEntity) {
                        EssenceBlockEntity essenceBlockEntity = (EssenceBlockEntity)((Object)grapplingHookData);
                        List<EssenceType> supported = EssenceMeter.currentMachineEssenceValue.values.keySet().stream().sorted(Comparator.comparing(i -> i.tier)).toList();
                        Map<EssenceType, Float> values = EssenceMeter.currentMachineEssenceValue.values;
                        float max = EssenceMeter.currentMachineEssenceValue.maxValue;
                        float shift = -((float)supported.size() - 1.0f) / 2.0f;
                        int width = 13 * supported.size();
                        int height = 65;
                        float worldWidth = (float)width / 96.0f;
                        float worldHeight = (float)height / 96.0f;
                        RenderProjectionUtil.project(graphics -> {
                            float shift2 = shift;
                            for (EssenceType i : supported) {
                                ClientEssenceBarUtil.drawEssenceIcon(graphics, (int)((float)width / 2.0f - 4.0f + shift2 * 13.0f), 0, i, essenceBlockEntity.getMeterBackgroundType(), false, ClientPlayerData.getUnlockedEssences().getOrDefault(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)i), false));
                                ClientEssenceBarUtil.drawEssenceBar(graphics, (int)((float)width / 2.0f - 4.0f + shift2 * 13.0f) + 1, 12, i, ((Float)values.get(i)).floatValue(), max, essenceBlockEntity.getMeterBackgroundType());
                                shift2 += 1.0f;
                            }
                        }, poseStack -> {
                            Vec3 center = blockHitResult.getBlockPos().getCenter();
                            Vec2 angle = ClientEvents.calculateRotationVector(center, Minecraft.getInstance().player.getEyePosition());
                            boolean horizontal = true;
                            if (mc.player.getEyePosition().y >= center.y + (double)essenceBlockEntity.getMeterSideLength(Direction.UP)) {
                                if (mc.level.getBlockState(blockHitResult.getBlockPos().above()).isAir()) {
                                    center = center.add(0.0, (double)(essenceBlockEntity.getMeterSideLength(Direction.UP) + essenceBlockEntity.getMeterRenderOffset(Direction.UP)), 0.0);
                                    horizontal = false;
                                }
                            } else if (mc.player.getEyePosition().y <= center.y - (double)essenceBlockEntity.getMeterSideLength(Direction.DOWN) && mc.level.getBlockState(blockHitResult.getBlockPos().below()).isAir()) {
                                center = center.add(0.0, (double)(-(essenceBlockEntity.getMeterSideLength(Direction.DOWN) + essenceBlockEntity.getMeterRenderOffset(Direction.DOWN))), 0.0);
                                horizontal = false;
                            }
                            if (horizontal) {
                                Direction direction = Direction.fromYRot((double)angle.y);
                                float offset = essenceBlockEntity.getMeterSideLength(direction) + essenceBlockEntity.getMeterRenderOffset(direction);
                                center = center.add((double)((float)direction.getStepX() * offset), 0.0, (double)((float)direction.getStepZ() * offset));
                            }
                            poseStack.pushPose();
                            poseStack.translate(center.x, center.y, center.z);
                            poseStack.pushPose();
                            poseStack.mulPose(Axis.YP.rotationDegrees(-angle.y + 180.0f));
                        }, poseStack -> {
                            poseStack.popPose();
                            poseStack.popPose();
                        }, (MultiBufferSource.BufferSource)bufferSource, (Vec3)new Vec3((double)(-worldWidth / 2.0f), (double)(worldHeight / 2.0f), 0.0), (Vec3)new Vec3((double)(worldWidth / 2.0f), (double)(worldHeight / 2.0f), 0.0), (Vec3)new Vec3((double)(worldWidth / 2.0f), (double)(-worldHeight / 2.0f), 0.0), (Vec3)new Vec3((double)(-worldWidth / 2.0f), (double)(-worldHeight / 2.0f), 0.0), (int)width, (int)height);
                    }
                }
            }
            if (!ShaderHelper.shouldUseAlternateRendering()) {
                ClientEvents.renderObjects(event);
            }
        }
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_LEVEL)) {
            if (ShaderHelper.shouldUseAlternateRendering()) {
                RenderSystem.getModelViewStack().pushMatrix().set((Matrix4fc)RenderHandler.matrix4f);
                RenderSystem.applyModelViewMatrix();
                RenderSystem.setShaderFogStart((float)RenderHandler.fogStart);
                ClientEvents.renderObjects(event);
                FogRenderer.setupNoFog();
                RenderSystem.getModelViewStack().popMatrix();
                RenderSystem.applyModelViewMatrix();
            }
            if (mc.player != null) {
                ClientModEvents.genderEuphoriaShader.setActive(DataNEssenceClientConfig.genderEuphoriaShader && mc.player.hasEffect(MobEffectRegistry.GENDER_EUPHORIA));
            }
        }
    }

    private static Vec2 calculateRotationVector(Vec3 pVec, Vec3 pTarget) {
        double d0 = pTarget.x - pVec.x;
        double d1 = pTarget.y - pVec.y;
        double d2 = pTarget.z - pVec.z;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        return new Vec2(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875)))), Mth.wrapDegrees((float)((float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f)));
    }

    private static void renderObjects(RenderLevelStageEvent event) {
        ClientEvents.copyBuffers();
        DataNEssenceCoreShaders.WARPING_POINT.setSampler("DepthBuffer", (Object)tempRenderTarget.getDepthTextureId());
        DataNEssenceCoreShaders.WARPING_POINT.setSampler("ColorBuffer", (Object)tempRenderTarget.getColorTextureId());
        MultiBufferSource.BufferSource bufferSource = RenderHandler.createBufferSource();
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(-event.getCamera().getPosition().x, -event.getCamera().getPosition().y, -event.getCamera().getPosition().z);
        for (Entity entity : Minecraft.getInstance().level.entitiesForRendering()) {
            if (!(entity instanceof BlackHole)) continue;
            BlackHole hole = (BlackHole)entity;
            Vec3 pos = entity.getBoundingBox().getCenter();
            ClientRenderingUtil.renderBlackHole(poseStack, pos, (MultiBufferSource)bufferSource, ((Float)hole.getEntityData().get(BlackHole.SIZE)).floatValue(), 16, 16);
            ClientRenderingUtil.renderBlackHole(poseStack, pos, (MultiBufferSource)bufferSource, -((Float)hole.getEntityData().get(BlackHole.SIZE)).floatValue(), 16, 16);
        }
        poseStack.popPose();
        for (Map.Entry entry : PingsGuiLayer.pings.entrySet()) {
            StructurePing ping = (StructurePing)entry.getKey();
            ClientLevel world = Minecraft.getInstance().level;
            Vec3 pos = ping.pos.getCenter();
            Vec3 posLow = new Vec3(pos.x, (double)world.getMinBuildHeight(), pos.z);
            Vec3 posHigh = new Vec3(pos.x, (double)world.getMaxBuildHeight(), pos.z);
            PingableStructure structure = ping.getPingableStructure();
            Color color1 = ping.known ? structure.color1 : new Color(0xB100B1);
            Color color2 = ping.known ? structure.color2 : new Color(0xFF00FF);
            long gameTime = 0L;
            if (Minecraft.getInstance().level != null) {
                gameTime = Minecraft.getInstance().level.getGameTime();
            }
            Color color = ColorUtil.blendColors((Color)color1, (Color)color2, (float)((org.joml.Math.sin((float)(((float)gameTime + Minecraft.getInstance().getTimer().getGameTimeDeltaTicks()) / 15.0f)) + 1.0f) / 2.0f));
            poseStack.pushPose();
            poseStack.translate(-event.getCamera().getPosition().x, -event.getCamera().getPosition().y, -event.getCamera().getPosition().z);
            RenderingUtil.renderAdvancedBeaconBeam((PoseStack)poseStack, (MultiBufferSource)bufferSource, (ResourceLocation)BeaconRenderer.BEAM_LOCATION, (float)event.getPartialTick().getGameTimeDeltaPartialTick(true), (float)1.0f, (long)gameTime, (Vec3)posLow, (Vec3)posHigh, (Color)color, (float)0.25f, (float)0.3f);
            poseStack.popPose();
        }
    }

    public static void copyBuffers() {
        if (tempRenderTarget == null) {
            return;
        }
        RenderTarget mainRenderTarget = Minecraft.getInstance().getMainRenderTarget();
        tempRenderTarget.copyDepthFrom(mainRenderTarget);
        ClientEvents.copyColorFrom(tempRenderTarget, mainRenderTarget);
        GlStateManager._glBindFramebuffer((int)36009, (int)mainRenderTarget.frameBufferId);
    }

    public static void copyColorFrom(RenderTarget tempRenderTarget, RenderTarget renderTarget) {
        RenderSystem.assertOnRenderThreadOrInit();
        GlStateManager._glBindFramebuffer((int)36008, (int)renderTarget.frameBufferId);
        GlStateManager._glBindFramebuffer((int)36009, (int)tempRenderTarget.frameBufferId);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)renderTarget.width, (int)renderTarget.height, (int)0, (int)0, (int)tempRenderTarget.width, (int)tempRenderTarget.height, (int)16384, (int)9728);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        time += 0.05f;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null) {
            SoundManager manager;
            for (Object i : PingsGuiLayer.pings.entrySet().stream().toList()) {
                if ((Integer)i.getValue() - 1 <= 0) {
                    PingsGuiLayer.pings.remove(i.getKey());
                    continue;
                }
                PingsGuiLayer.pings.put((StructurePing)i.getKey(), (Integer)i.getValue() - 1);
            }
            if (mc.player != null) {
                boolean playedASound = false;
                for (Map.Entry i : AddScannedOre.scanned.entrySet().stream().toList()) {
                    int value = (Integer)i.getValue() - 1;
                    if ((Integer)i.getValue() > 0 && value <= 0 && !playedASound) {
                        mc.level.playSound((Player)mc.player, (BlockPos)i.getKey(), (SoundEvent)SoundRegistry.SCAN_ORE.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        playedASound = true;
                    }
                    if (value <= -100) {
                        AddScannedOre.scanned.remove(i.getKey());
                        continue;
                    }
                    AddScannedOre.scanned.put((BlockPos)i.getKey(), value);
                }
            }
            boolean playMusic = false;
            SoundEvent mus = null;
            if (mc.player != null) {
                GrapplingHook.GrapplingHookData grapplingHookData;
                HitResult value = mc.hitResult;
                if (value instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)value;
                    if (mc.player.isHolding(item -> item.getItem() instanceof EssenceMeter) && mc.level.getBlockEntity(blockHitResult.getBlockPos()) instanceof EssenceBlockEntity) {
                        ModMessages.sendToServer(new RequestMachineEssenceValue(blockHitResult.getBlockPos()));
                    }
                }
                if ((grapplingHookData = (GrapplingHook.GrapplingHookData)((Optional)mc.player.getData(AttachmentTypeRegistry.GRAPPLING_HOOK_DATA)).orElse(null)) != null && mc.player.position().distanceTo(grapplingHookData.pos) > 0.0) {
                    Vector3d direction = new Vector3d((Vector3fc)grapplingHookData.pos.subtract(mc.player.position()).toVector3f()).normalize();
                    double theta = direction.angle((Vector3dc)new Vector3d(0.0, 1.0, 0.0));
                    double angle = org.joml.Math.toDegrees((double)theta);
                    double distanceToUp = org.joml.Math.abs((double)(180.0 - (angle > 180.0 ? 180.0 - (angle - 180.0) : angle)));
                    double intensity = 1.0;
                    if (distanceToUp <= 90.0) {
                        intensity = distanceToUp / 90.0;
                    }
                    double centripetalAcceleration = mc.player.getDeltaMovement().lengthSqr() / (1.0 + grapplingHookData.distance);
                    double mass = 1.0;
                    double gravity = mc.player.getGravity();
                    Vector3d tension = new Vector3d((Vector3dc)direction).mul(mass * (centripetalAcceleration + gravity * org.joml.Math.cos((double)theta)));
                    Vector3d force = new Vector3d((Vector3dc)tension).div(mass);
                    mc.player.setDeltaMovement(mc.player.getDeltaMovement().add(new Vec3(force.x, force.y > 0.0 ? force.y * intensity : force.y, force.z)));
                }
                for (int index = 0; index < mc.player.getInventory().getContainerSize(); ++index) {
                    SoundEvent sound;
                    ResourceKey key;
                    ItemStack slot = mc.player.getInventory().getItem(index);
                    if (!slot.is(ItemRegistry.MUSIC_DISC_PLAYER.get()) || (key = (ResourceKey)slot.get(DataComponentRegistry.PLAYING_MUSIC)) == null || (sound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(key)) == null) continue;
                    mus = sound;
                    playMusic = true;
                    break;
                }
            }
            if ((manager = mc.getSoundManager()).isActive((SoundInstance)musicDiscPlayerMusic)) {
                if (!playMusic) {
                    manager.stop((SoundInstance)musicDiscPlayerMusic);
                } else if (!musicDiscPlayerMusic.getLocation().equals((Object)mus.getLocation())) {
                    manager.stop((SoundInstance)musicDiscPlayerMusic);
                }
            }
            if (!manager.isActive((SoundInstance)musicDiscPlayerMusic) && !manager.isActive((SoundInstance)musicDiscPlayerMusic) && playMusic) {
                musicDiscPlayerMusic = new SimpleSoundInstance(mus.getLocation(), SoundSource.RECORDS, 1.0f, 1.0f, SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
                manager.play((SoundInstance)musicDiscPlayerMusic);
            }
        } else {
            PingsGuiLayer.pings.clear();
            AddScannedOre.scanned.clear();
        }
    }
}

