/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.transmission;

import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.node.ICustomEssencePointBehaviour;
import com.cmdpro.datanessence.api.node.block.BaseEssencePointBlockEntity;
import com.cmdpro.datanessence.config.DataNEssenceConfig;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jgrapht.GraphPath;
import org.jgrapht.graph.DefaultEdge;
import org.joml.Math;

public class ExoticEssencePointBlockEntity
extends BaseEssencePointBlockEntity {
    public ExoticEssencePointBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.EXOTIC_ESSENCE_POINT.get(), pos, state);
    }

    @Override
    public Color linkColor() {
        return new Color(EssenceTypeRegistry.EXOTIC_ESSENCE.get().getColor());
    }

    @Override
    public void transfer(BaseEssencePointBlockEntity from, List<GraphPath<BlockPos, DefaultEdge>> other) {
        int transferAmount = (int)Math.floor((float)((float)this.getFinalSpeed(DataNEssenceConfig.essencePointTransfer) / (float)other.size()));
        for (GraphPath<BlockPos, DefaultEdge> i : other) {
            ICustomEssencePointBehaviour behaviour;
            BlockEntity blockEntity = this.level.getBlockEntity((BlockPos)i.getEndVertex());
            if (!(blockEntity instanceof BaseEssencePointBlockEntity)) continue;
            BaseEssencePointBlockEntity entity = (BaseEssencePointBlockEntity)blockEntity;
            BlockEntity fromEnt = from.getLevel().getBlockEntity(from.getBlockPos().relative(from.getDirection().getOpposite()));
            BlockEntity toEnt = entity.getLevel().getBlockEntity(entity.getBlockPos().relative(entity.getDirection().getOpposite()));
            if (!(fromEnt instanceof EssenceBlockEntity)) continue;
            EssenceBlockEntity fromStorage = (EssenceBlockEntity)fromEnt;
            if (!(toEnt instanceof EssenceBlockEntity)) continue;
            EssenceBlockEntity toStorage = (EssenceBlockEntity)toEnt;
            if (fromEnt instanceof ICustomEssencePointBehaviour && !(behaviour = (ICustomEssencePointBehaviour)fromEnt).canExtractEssence(fromStorage.getStorage(), toStorage.getStorage(), EssenceTypeRegistry.EXOTIC_ESSENCE.get(), transferAmount)) {
                return;
            }
            if (toEnt instanceof ICustomEssencePointBehaviour && !(behaviour = (ICustomEssencePointBehaviour)toEnt).canInsertEssence(fromStorage.getStorage(), toStorage.getStorage(), EssenceTypeRegistry.EXOTIC_ESSENCE.get(), transferAmount)) {
                return;
            }
            EssenceStorage.transferEssence(fromStorage.getStorage(), toStorage.getStorage(), EssenceTypeRegistry.EXOTIC_ESSENCE.get(), transferAmount);
            this.updateBlock(fromEnt);
            this.updateBlock(toEnt);
        }
    }

    public void updateBlock(BlockEntity ent) {
        BlockState blockState = this.level.getBlockState(ent.getBlockPos());
        this.level.sendBlockUpdated(ent.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }
}

