/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.technical;

import com.cmdpro.datanessence.block.technical.StructureProtector;
import com.cmdpro.datanessence.client.particle.CircleParticleOptions;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class StructureProtectorBlockEntity
extends BlockEntity {
    public BlockPos offsetCorner1;
    public BlockPos offsetCorner2;
    public int bindProcess;

    public StructureProtectorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.STRUCTURE_PROTECTOR.get(), pos, state);
        this.offsetCorner1 = pos;
        this.offsetCorner2 = pos;
        this.bindProcess = 0;
    }

    public void setLevel(Level pLevel) {
        if (this.level != null && !this.level.isClientSide) {
            ((ArrayList)this.level.getData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS)).remove((Object)this);
        }
        super.setLevel(pLevel);
        if (!pLevel.isClientSide && !((ArrayList)pLevel.getData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS)).contains((Object)this)) {
            ((ArrayList)pLevel.getData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS)).add(this);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level != null && !this.level.isClientSide) {
            ((ArrayList)this.level.getData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS)).remove((Object)this);
        }
    }

    public Rotation getRotation(Direction direction) {
        Rotation rot = Rotation.NONE;
        if (direction.equals((Object)Direction.EAST)) {
            rot = Rotation.CLOCKWISE_90;
        }
        if (direction.equals((Object)Direction.SOUTH)) {
            rot = Rotation.CLOCKWISE_180;
        }
        if (direction.equals((Object)Direction.WEST)) {
            rot = Rotation.COUNTERCLOCKWISE_90;
        }
        return rot;
    }

    public Rotation getRotation() {
        return this.getRotation((Direction)this.getBlockState().getValue((Property)StructureProtector.FACING));
    }

    public BlockPos getCorner1() {
        if (this.offsetCorner1 == null) {
            return null;
        }
        return this.getBlockPos().offset((Vec3i)this.offsetCorner1.rotate(this.getRotation()));
    }

    public BlockPos getCorner2() {
        if (this.offsetCorner2 == null) {
            return null;
        }
        return this.getBlockPos().offset((Vec3i)this.offsetCorner2.rotate(this.getRotation()));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.offsetCorner1 = tag.contains("offsetCorner1X") && tag.contains("offsetCorner1Y") && tag.contains("offsetCorner1Z") ? new BlockPos(tag.getInt("offsetCorner1X"), tag.getInt("offsetCorner1Y"), tag.getInt("offsetCorner1Z")) : null;
        this.offsetCorner2 = tag.contains("offsetCorner2X") && tag.contains("offsetCorner2Y") && tag.contains("offsetCorner2Z") ? new BlockPos(tag.getInt("offsetCorner2X"), tag.getInt("offsetCorner2Y"), tag.getInt("offsetCorner2Z")) : null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        if (this.offsetCorner1 != null) {
            tag.putInt("offsetCorner1X", this.offsetCorner1.getX());
            tag.putInt("offsetCorner1Y", this.offsetCorner1.getY());
            tag.putInt("offsetCorner1Z", this.offsetCorner1.getZ());
        }
        if (this.offsetCorner2 != null) {
            tag.putInt("offsetCorner2X", this.offsetCorner2.getX());
            tag.putInt("offsetCorner2Y", this.offsetCorner2.getY());
            tag.putInt("offsetCorner2Z", this.offsetCorner2.getZ());
        }
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (this.offsetCorner1 != null) {
            tag.putInt("offsetCorner1X", this.offsetCorner1.getX());
            tag.putInt("offsetCorner1Y", this.offsetCorner1.getY());
            tag.putInt("offsetCorner1Z", this.offsetCorner1.getZ());
        }
        if (this.offsetCorner2 != null) {
            tag.putInt("offsetCorner2X", this.offsetCorner2.getX());
            tag.putInt("offsetCorner2Y", this.offsetCorner2.getY());
            tag.putInt("offsetCorner2Z", this.offsetCorner2.getZ());
        }
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.offsetCorner1 = tag.contains("offsetCorner1X") && tag.contains("offsetCorner1Y") && tag.contains("offsetCorner1Z") ? new BlockPos(tag.getInt("offsetCorner1X"), tag.getInt("offsetCorner1Y"), tag.getInt("offsetCorner1Z")) : null;
        this.offsetCorner2 = tag.contains("offsetCorner2X") && tag.contains("offsetCorner2Y") && tag.contains("offsetCorner2Z") ? new BlockPos(tag.getInt("offsetCorner2X"), tag.getInt("offsetCorner2Y"), tag.getInt("offsetCorner2Z")) : null;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, StructureProtectorBlockEntity pBlockEntity) {
        if (pLevel.isClientSide) {
            ClientHandler.spawnParticles(pLevel.random, pPos.getCenter());
        }
    }

    public void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        public static void spawnParticles(RandomSource random, Vec3 pos) {
            for (int i = 0; i < 5; ++i) {
                Vec3 dir = new Vec3((double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f), (double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f), (double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f)).normalize().multiply((double)0.1f, (double)0.1f, (double)0.1f);
                Vec3 offset = new Vec3((double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f), (double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f), (double)Mth.nextFloat((RandomSource)random, (float)-1.0f, (float)1.0f)).normalize().multiply((double)0.1f, (double)0.1f, (double)0.1f);
                Minecraft.getInstance().particleEngine.createParticle((ParticleOptions)new CircleParticleOptions().setColor(Color.getHSBColor((float)(Minecraft.getInstance().level.getGameTime() % 100L) / 100.0f, 1.0f, 1.0f)).setAdditive(true), pos.x + offset.x, pos.y + offset.y, pos.z + offset.z, dir.x, dir.y, dir.z);
            }
        }
    }
}

