/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.storage;

import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.InfiniteEssenceContainer;
import com.cmdpro.datanessence.config.DataNEssenceConfig;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class CreativeEssenceBatteryBlockEntity
extends BlockEntity
implements EssenceBlockEntity {
    public InfiniteEssenceContainer storage = new InfiniteEssenceContainer(DataNEssenceConfig.essenceBatteryMax);

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public CreativeEssenceBatteryBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.CREATIVE_ESSENCE_BATTERY.get(), pos, state);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        this.storage.fromNbt(pkt.getTag().getCompound("EssenceStorage"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

