/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.production;

import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.block.production.FluidCollector;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class FluidCollectorBlockEntity
extends BlockEntity
implements EssenceBlockEntity {
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    public int cooldown;
    private final FluidTank fluidHandler = new FluidTank(4000);

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public FluidCollectorBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.FLUID_COLLECTOR.get(), pos, state);
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.put("fluid", (Tag)this.fluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        tag.putInt("cooldown", this.cooldown);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.fluidHandler.readFromNBT(pRegistries, nbt.getCompound("fluid"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.cooldown = nbt.getInt("cooldown");
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, FluidCollectorBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            if (pBlockEntity.cooldown <= 0) {
                FluidStack stack;
                BlockPos pos;
                FluidState state;
                if (pBlockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) >= 25.0f && !(state = pLevel.getFluidState(pos = pPos.relative((Direction)pState.getValue((Property)FluidCollector.FACING)))).isEmpty() && state.isSource() && pBlockEntity.fluidHandler.fill(stack = new FluidStack(state.getType(), 1000), IFluidHandler.FluidAction.SIMULATE) > 0) {
                    pBlockEntity.fluidHandler.fill(stack, IFluidHandler.FluidAction.EXECUTE);
                    pLevel.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                    pLevel.playSound(null, pPos, (SoundEvent)SoundRegistry.FLUID_COLLECTOR_FILL.value(), SoundSource.BLOCKS, 2.0f, 1.0f);
                    pBlockEntity.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), 25.0f);
                    pBlockEntity.cooldown = 20;
                }
            } else {
                --pBlockEntity.cooldown;
            }
        }
    }
}

