/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.processing;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.LockableItemHandler;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.api.essence.container.MultiEssenceContainer;
import com.cmdpro.datanessence.api.misc.ILockableContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.client.FactorySong;
import com.cmdpro.datanessence.item.DataDrive;
import com.cmdpro.datanessence.recipe.SynthesisRecipe;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.screen.SynthesisChamberMenu;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SynthesisChamberBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity,
ILockableContainer {
    public MultiEssenceContainer storage = new MultiEssenceContainer(List.of(EssenceTypeRegistry.ESSENCE.get(), EssenceTypeRegistry.LUNAR_ESSENCE.get(), EssenceTypeRegistry.NATURAL_ESSENCE.get(), EssenceTypeRegistry.EXOTIC_ESSENCE.get()), 1000.0f);
    private final LockableItemHandler itemHandler = new LockableItemHandler(2){

        protected void onContentsChanged(int slot) {
            SynthesisChamberBlockEntity.this.setChanged();
            SynthesisChamberBlockEntity.this.checkRecipes();
        }

        @Override
        public void setLockedSlots() {
            super.setLockedSlots();
            SynthesisChamberBlockEntity.this.setChanged();
        }

        @Override
        public void setLocked(boolean locked) {
            super.setLocked(locked);
            SynthesisChamberBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return super.isItemValid(slot, stack);
        }
    };
    private final ItemStackHandler dataDriveHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            SynthesisChamberBlockEntity.this.setChanged();
            SynthesisChamberBlockEntity.this.checkRecipes();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.getItem() instanceof DataDrive;
        }
    };
    private final ItemStackHandler outputItemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            SynthesisChamberBlockEntity.this.setChanged();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.dataDriveHandler, this.outputItemHandler});
    public ItemStack item = ItemStack.EMPTY;
    public SynthesisRecipe recipe;
    public boolean enoughEssence;
    public Map<ResourceLocation, Float> essenceCost;
    public int workTime;
    public int maxWorkTime;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getDataDriveHandler() {
        return this.dataDriveHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputItemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public SynthesisChamberBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.SYNTHESIS_CHAMBER.get(), pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.item = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound("item"));
        this.workTime = tag.getInt("workTime");
        this.itemHandler.deserializeNBT(pRegistries, tag.getCompound("itemHandler"));
        this.maxWorkTime = tag.getInt("maxWorkTime");
        if (tag.contains("essenceCost")) {
            CompoundTag cost = tag.getCompound("essenceCost");
            this.essenceCost = new HashMap<ResourceLocation, Float>();
            for (String i : cost.getAllKeys()) {
                ResourceLocation location = ResourceLocation.tryParse((String)i);
                this.essenceCost.put(location, Float.valueOf(cost.getFloat(i)));
            }
        } else {
            this.essenceCost = null;
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.put("item", this.item.saveOptional(pRegistries));
        tag.putInt("workTime", this.workTime);
        tag.putInt("maxWorkTime", this.recipe == null ? -1 : this.recipe.getTime());
        tag.put("itemHandler", (Tag)this.itemHandler.serializeNBT(pRegistries));
        if (this.essenceCost != null) {
            CompoundTag cost = new CompoundTag();
            for (Map.Entry<ResourceLocation, Float> i : this.essenceCost.entrySet()) {
                cost.putFloat(i.getKey().toString(), i.getValue().floatValue());
            }
            tag.put("essenceCost", (Tag)cost);
        }
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("inventoryOutput", (Tag)this.outputItemHandler.serializeNBT(pRegistries));
        tag.put("inventoryDrive", (Tag)this.dataDriveHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
        this.outputItemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventoryOutput"));
        this.dataDriveHandler.deserializeNBT(pRegistries, nbt.getCompound("inventoryDrive"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.workTime = nbt.getInt("workTime");
    }

    public SimpleContainer getInv() {
        int i;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + this.outputItemHandler.getSlots() + this.dataDriveHandler.getSlots());
        for (i = 0; i < this.dataDriveHandler.getSlots(); ++i) {
            inventory.setItem(i, this.dataDriveHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.dataDriveHandler.getSlots(), this.itemHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.outputItemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.dataDriveHandler.getSlots() + this.itemHandler.getSlots(), this.outputItemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public RecipeInput getCraftingInv() {
        RecipeInput inventory = new RecipeInput(){

            public ItemStack getItem(int pIndex) {
                return SynthesisChamberBlockEntity.this.itemHandler.getStackInSlot(pIndex);
            }

            public int size() {
                return 2;
            }
        };
        return inventory;
    }

    public void checkRecipes() {
        Optional<RecipeHolder> recipe = this.level.getRecipeManager().getRecipesFor(RecipeRegistry.SYNTHESIS_TYPE.get(), this.getCraftingInv(), this.level).stream().filter(a -> ((SynthesisRecipe)a.value()).getEntry().equals((Object)DataDrive.getEntryId(this.dataDriveHandler.getStackInSlot(0)))).findFirst();
        if (recipe.isPresent()) {
            if (!((SynthesisRecipe)recipe.get().value()).equals(this.recipe)) {
                this.workTime = 0;
            }
            if (this.dataDriveHandler.getStackInSlot(0).has(DataComponentRegistry.DATA_ID) && this.dataDriveHandler.getStackInSlot(0).has(DataComponentRegistry.DATA_INCOMPLETE)) {
                if (((SynthesisRecipe)recipe.get().value()).getEntry().equals((Object)DataDrive.getEntryId(this.dataDriveHandler.getStackInSlot(0))) && DataDrive.getEntryCompletionStage(this.dataDriveHandler.getStackInSlot(0)) >= ((SynthesisRecipe)recipe.get().value()).getCompletionStage()) {
                    this.recipe = (SynthesisRecipe)recipe.get().value();
                    this.essenceCost = ((SynthesisRecipe)recipe.get().value()).getEssenceCost();
                } else {
                    this.recipe = null;
                }
            } else {
                this.recipe = null;
            }
        } else {
            this.recipe = null;
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, SynthesisChamberBlockEntity synthesisChamber) {
        if (!pLevel.isClientSide()) {
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)synthesisChamber, List.of(EssenceTypeRegistry.ESSENCE.get(), EssenceTypeRegistry.LUNAR_ESSENCE.get(), EssenceTypeRegistry.NATURAL_ESSENCE.get(), EssenceTypeRegistry.EXOTIC_ESSENCE.get()));
            for (LockableItemHandler lockedSlot : synthesisChamber.getLockable()) {
                if (lockedSlot.locked) continue;
                return;
            }
            BufferUtil.getItemsFromBuffersBelow(synthesisChamber, (IItemHandler)synthesisChamber.itemHandler);
            boolean resetWorkTime = true;
            if (synthesisChamber.recipe != null) {
                ItemStack result;
                boolean enoughEssence = true;
                for (Map.Entry<ResourceLocation, Float> i : synthesisChamber.essenceCost.entrySet()) {
                    EssenceType type = (EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(i.getKey());
                    if (!(synthesisChamber.storage.getEssence(type) < i.getValue().floatValue() / (float)synthesisChamber.recipe.getTime())) continue;
                    enoughEssence = false;
                }
                synthesisChamber.enoughEssence = enoughEssence;
                if (enoughEssence && synthesisChamber.outputItemHandler.insertItem(0, result = synthesisChamber.recipe.getResultItem((HolderLookup.Provider)pLevel.registryAccess()), true).isEmpty()) {
                    resetWorkTime = false;
                    ++synthesisChamber.workTime;
                    for (Map.Entry<ResourceLocation, Float> i : synthesisChamber.essenceCost.entrySet()) {
                        EssenceType type = (EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(i.getKey());
                        synthesisChamber.storage.removeEssence(type, i.getValue().floatValue() / (float)synthesisChamber.recipe.getTime());
                    }
                    if (synthesisChamber.workTime >= synthesisChamber.recipe.getTime()) {
                        synthesisChamber.outputItemHandler.insertItem(0, synthesisChamber.recipe.assemble(synthesisChamber.getCraftingInv(), (HolderLookup.Provider)pLevel.registryAccess()), false);
                        synthesisChamber.itemHandler.extractItem(0, 1, false);
                        synthesisChamber.itemHandler.extractItem(1, 1, false);
                        synthesisChamber.workTime = 0;
                    }
                }
            }
            if (resetWorkTime) {
                synthesisChamber.workTime = -1;
            }
            synthesisChamber.updateBlock();
        } else if (synthesisChamber.workTime >= 0 && synthesisChamber.essenceCost != null && synthesisChamber.itemHandler.locked && synthesisChamber.essenceCost.containsKey(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)EssenceTypeRegistry.ESSENCE.get()))) {
            ClientHandler.markIndustrialFactorySong(pPos);
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.checkRecipes();
        }
    }

    private static boolean hasNotReachedStackLimit(SynthesisChamberBlockEntity entity, ItemStack toAdd) {
        if (toAdd.is(entity.outputItemHandler.getStackInSlot(0).getItem())) {
            return entity.outputItemHandler.getStackInSlot(0).getCount() + toAdd.getCount() <= entity.outputItemHandler.getStackInSlot(0).getMaxStackSize();
        }
        return entity.outputItemHandler.getStackInSlot(0).isEmpty();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new SynthesisChamberMenu(pContainerId, pInventory, this);
    }

    @Override
    public List<LockableItemHandler> getLockable() {
        return List.of(this.itemHandler);
    }

    private static class ClientHandler {
        static FactorySong.FactoryLoop industrialSound = FactorySong.getLoop((SoundEvent)SoundRegistry.SYNTHESIS_LOOP_INDUSTRIAL.value());

        private ClientHandler() {
        }

        public static void markIndustrialFactorySong(BlockPos pos) {
            industrialSound.addSource(pos);
        }
    }
}

