/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.processing;

import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.recipe.MineralPurificationRecipe;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.screen.MineralPurificationChamberMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MineralPurificationChamberBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity {
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            MineralPurificationChamberBlockEntity.this.setChanged();
            MineralPurificationChamberBlockEntity.this.checkRecipes();
        }
    };
    private final ItemStackHandler outputItemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            MineralPurificationChamberBlockEntity.this.setChanged();
        }
    };
    private final FluidTank waterFluidHandler = new FluidTank(this, 2000){

        public boolean isFluidValid(FluidStack stack) {
            return stack.is((Fluid)Fluids.WATER);
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.outputItemHandler});
    public float maxTime;
    public int workTime;
    public MineralPurificationRecipe recipe;
    public float essenceCost;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.checkRecipes();
        }
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IFluidHandler getWaterHandler() {
        return this.waterFluidHandler;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputItemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public MineralPurificationChamberBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.MINERAL_PURIFICATION_CHAMBER.get(), pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.workTime = tag.getInt("workTime");
        this.maxTime = tag.getInt("maxTime");
        this.waterFluidHandler.readFromNBT(pRegistries, tag.getCompound("waterHandler"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        tag.putInt("maxTime", this.recipe == null ? -1 : this.recipe.getTime());
        tag.put("waterHandler", (Tag)this.waterFluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("input", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("output", (Tag)this.outputItemHandler.serializeNBT(pRegistries));
        tag.put("water", (Tag)this.waterFluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("input"));
        this.outputItemHandler.deserializeNBT(pRegistries, nbt.getCompound("output"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.waterFluidHandler.readFromNBT(pRegistries, nbt.getCompound("water"));
        this.workTime = nbt.getInt("workTime");
    }

    public SimpleContainer getInv() {
        int i;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + this.outputItemHandler.getSlots());
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.outputItemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.itemHandler.getSlots(), this.outputItemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public RecipeInput getCraftingInv() {
        SingleRecipeInput inventory = new SingleRecipeInput(this.itemHandler.getStackInSlot(0));
        return inventory;
    }

    public void checkRecipes() {
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeRegistry.MINERAL_PURIFICATION_TYPE.get(), this.getCraftingInv(), this.level);
        if (recipe.isPresent()) {
            if (!((MineralPurificationRecipe)((RecipeHolder)recipe.get()).value()).equals(this.recipe)) {
                this.workTime = 0;
            }
            this.recipe = (MineralPurificationRecipe)((RecipeHolder)recipe.get()).value();
        } else {
            this.recipe = null;
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, MineralPurificationChamberBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)pBlockEntity, EssenceTypeRegistry.ESSENCE.get());
            BufferUtil.getItemsFromBuffersBelow(pBlockEntity, (IItemHandler)pBlockEntity.itemHandler);
            BufferUtil.getFluidsFromBuffersBelow(pBlockEntity, (IFluidHandler)pBlockEntity.waterFluidHandler);
            boolean resetWorkTime = true;
            if (pBlockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) >= 1.0f && pBlockEntity.waterFluidHandler.getFluidAmount() >= 250 && pBlockEntity.recipe != null) {
                ItemStack assembled = pBlockEntity.recipe.assemble(pBlockEntity.getCraftingInv(), (HolderLookup.Provider)pLevel.registryAccess());
                ItemStack assembled2 = pBlockEntity.recipe.assembleNuggetOutput(pLevel.random, pBlockEntity.getCraftingInv(), (HolderLookup.Provider)pLevel.registryAccess());
                if (pBlockEntity.outputItemHandler.insertItem(0, assembled, true).isEmpty() && pBlockEntity.outputItemHandler.insertItem(1, assembled2, true).isEmpty()) {
                    resetWorkTime = false;
                    ++pBlockEntity.workTime;
                    pBlockEntity.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), 1.0f);
                    if (pBlockEntity.workTime >= pBlockEntity.recipe.getTime()) {
                        pBlockEntity.waterFluidHandler.drain(250, IFluidHandler.FluidAction.EXECUTE);
                        pBlockEntity.outputItemHandler.insertItem(0, assembled, false);
                        pBlockEntity.outputItemHandler.insertItem(1, assembled2, false);
                        pBlockEntity.itemHandler.extractItem(0, 1, false);
                        pLevel.playSound(null, pPos, (SoundEvent)SoundRegistry.MINERAL_PURIFICATION_CHAMBER_CRAFT.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        pBlockEntity.workTime = 0;
                    }
                }
            }
            if (resetWorkTime) {
                pBlockEntity.workTime = -1;
            }
            pBlockEntity.updateBlock();
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new MineralPurificationChamberMenu(pContainerId, pInventory, this);
    }
}

