/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.processing;

import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.recipe.MeltingRecipe;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.cmdpro.datanessence.screen.MelterMenu;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MelterBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity {
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            MelterBlockEntity.this.setChanged();
            MelterBlockEntity.this.checkRecipes();
        }
    };
    private final FluidTank outputFluidHandler = new FluidTank(2000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            MelterBlockEntity.this.updateBlock();
        }
    };
    private final FluidTank fuelFluidHandler = new FluidTank(2000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            MelterBlockEntity.this.updateBlock();
            MelterBlockEntity.this.checkRecipes();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler});
    public float maxTime;
    public int workTime;
    public MeltingRecipe recipe;
    public float essenceCost;
    public int drainCooldown;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.checkRecipes();
        }
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IFluidHandler getOutputHandler() {
        return this.outputFluidHandler;
    }

    public IFluidHandler getFuelHandler() {
        return this.fuelFluidHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public MelterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.MELTER.get(), pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.workTime = tag.getInt("workTime");
        this.maxTime = tag.getInt("maxTime");
        this.outputFluidHandler.readFromNBT(pRegistries, tag.getCompound("outputFluidHandler"));
        this.fuelFluidHandler.readFromNBT(pRegistries, tag.getCompound("fuelFluidHandler"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        tag.putInt("maxTime", this.recipe == null ? -1 : this.recipe.getTime());
        tag.put("outputFluidHandler", (Tag)this.outputFluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        tag.put("fuelFluidHandler", (Tag)this.fuelFluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("input", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        tag.put("outputFluidHandler", (Tag)this.outputFluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        tag.put("fuelFluidHandler", (Tag)this.fuelFluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("input"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.workTime = nbt.getInt("workTime");
        this.outputFluidHandler.readFromNBT(pRegistries, nbt.getCompound("outputFluidHandler"));
        this.fuelFluidHandler.readFromNBT(pRegistries, nbt.getCompound("fuelFluidHandler"));
    }

    public SimpleContainer getInv() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public RecipeInput getCraftingInv() {
        SingleRecipeInput inventory = new SingleRecipeInput(this.itemHandler.getStackInSlot(0));
        return inventory;
    }

    public void checkRecipes() {
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeRegistry.MELTING_TYPE.get(), this.getCraftingInv(), this.level);
        if (recipe.isPresent()) {
            if (!((MeltingRecipe)((RecipeHolder)recipe.get()).value()).equals(this.recipe)) {
                this.workTime = 0;
            }
            this.recipe = (MeltingRecipe)((RecipeHolder)recipe.get()).value();
        } else {
            this.recipe = null;
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, MelterBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)pBlockEntity, EssenceTypeRegistry.ESSENCE.get());
            BufferUtil.getItemsFromBuffersBelow(pBlockEntity, (IItemHandler)pBlockEntity.itemHandler);
            BufferUtil.getFluidsFromBuffersBelow(pBlockEntity, (IFluidHandler)pBlockEntity.fuelFluidHandler);
            boolean resetWorkTime = true;
            if (pBlockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) >= 1.0f) {
                if (pBlockEntity.recipe != null) {
                    FluidStack assembled = pBlockEntity.recipe.getOutput().copy();
                    if (pBlockEntity.getFuelHandler().drain(1, IFluidHandler.FluidAction.SIMULATE).getAmount() >= 1 && pBlockEntity.outputFluidHandler.fill(assembled, IFluidHandler.FluidAction.SIMULATE) >= assembled.getAmount()) {
                        resetWorkTime = false;
                        ++pBlockEntity.workTime;
                        ++pBlockEntity.drainCooldown;
                        if (pBlockEntity.drainCooldown >= 5) {
                            pBlockEntity.drainCooldown = 0;
                            pBlockEntity.getFuelHandler().drain(1, IFluidHandler.FluidAction.EXECUTE);
                        }
                        pBlockEntity.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), 1.0f);
                        if (pBlockEntity.workTime >= pBlockEntity.recipe.getTime()) {
                            pBlockEntity.outputFluidHandler.fill(assembled, IFluidHandler.FluidAction.EXECUTE);
                            pBlockEntity.itemHandler.extractItem(0, 1, false);
                            pBlockEntity.workTime = 0;
                        }
                        pBlockEntity.updateBlock();
                    }
                } else {
                    pBlockEntity.drainCooldown = 0;
                }
            } else {
                pBlockEntity.drainCooldown = 0;
            }
            if (resetWorkTime) {
                pBlockEntity.workTime = -1;
                pBlockEntity.updateBlock();
            }
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new MelterMenu(pContainerId, pInventory, this);
    }
}

