/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.processing;

import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.datanessence.api.MultiFluidTank;
import com.cmdpro.datanessence.api.MultiFluidTankNoDuplicateFluids;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.item.DataDrive;
import com.cmdpro.datanessence.recipe.FluidMixingRecipe;
import com.cmdpro.datanessence.recipe.RecipeInputWithFluid;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.cmdpro.datanessence.screen.FluidMixerMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidMixerBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity {
    public DatabankAnimationState animState = new DatabankAnimationState("idle").addAnim(new DatabankAnimationReference("idle", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("working", (state, anim) -> {}, (state, anim) -> {}));
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    public FluidMixingRecipe recipe;
    public boolean enoughEssence;
    public float essenceCost;
    public int workTime;
    public int maxWorkTime;
    public ItemStack item;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            FluidMixerBlockEntity.this.setChanged();
            FluidMixerBlockEntity.this.checkRecipes();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return super.isItemValid(slot, stack);
        }
    };
    private final ItemStackHandler dataDriveHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            FluidMixerBlockEntity.this.setChanged();
            FluidMixerBlockEntity.this.checkRecipes();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.getItem() instanceof DataDrive;
        }
    };
    private final MultiFluidTank fluidHandler = new MultiFluidTankNoDuplicateFluids(List.of(new FluidTank(1000){

        protected void onContentsChanged() {
            FluidMixerBlockEntity.this.checkRecipes();
        }
    }, new FluidTank(1000){

        protected void onContentsChanged() {
            FluidMixerBlockEntity.this.checkRecipes();
        }
    }));
    private final FluidTank outputFluidHandler = new FluidTank(1000);
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.dataDriveHandler});

    public void setLevel(Level level) {
        super.setLevel(level);
        this.animState.setLevel(level);
    }

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.checkRecipes();
        }
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getDataDriveHandler() {
        return this.dataDriveHandler;
    }

    public IFluidHandler getOutputHandler() {
        return this.outputFluidHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public FluidMixerBlockEntity(BlockPos pos, BlockState state2) {
        super(BlockEntityRegistry.FLUID_MIXER.get(), pos, state2);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.workTime = tag.getInt("workTime");
        this.maxWorkTime = tag.getInt("maxWorkTime");
        this.itemHandler.deserializeNBT(pRegistries, tag.getCompound("itemHandler"));
        this.fluidHandler.readFromNBT(pRegistries, tag.getCompound("fluidHandler"));
        this.outputFluidHandler.readFromNBT(pRegistries, tag.getCompound("outputFluidHandler"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        tag.putInt("maxWorkTime", this.recipe != null ? this.recipe.getTime() : -1);
        tag.put("itemHandler", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("fluidHandler", (Tag)this.fluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        tag.put("outputFluidHandler", (Tag)this.outputFluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("inventoryDrive", (Tag)this.dataDriveHandler.serializeNBT(pRegistries));
        tag.put("fluids", (Tag)this.fluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        tag.put("outputFluid", (Tag)this.outputFluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
        this.dataDriveHandler.deserializeNBT(pRegistries, nbt.getCompound("inventoryDrive"));
        this.fluidHandler.readFromNBT(pRegistries, nbt.getCompound("fluids"));
        this.outputFluidHandler.readFromNBT(pRegistries, nbt.getCompound("outputFluid"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.workTime = nbt.getInt("workTime");
    }

    public SimpleContainer getInv() {
        int i;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + this.dataDriveHandler.getSlots());
        for (i = 0; i < this.dataDriveHandler.getSlots(); ++i) {
            inventory.setItem(i, this.dataDriveHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.dataDriveHandler.getSlots(), this.itemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public RecipeInputWithFluid getCraftingInv() {
        SingleRecipeInput inventory = new SingleRecipeInput(this.itemHandler.getStackInSlot(0));
        ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
        for (int i = 0; i < this.fluidHandler.getTanks(); ++i) {
            fluids.add(this.fluidHandler.getFluidInTank(i));
        }
        return new RecipeInputWithFluid((RecipeInput)inventory, fluids);
    }

    public void checkRecipes() {
        Optional<RecipeHolder> recipe = this.level.getRecipeManager().getRecipesFor(RecipeRegistry.FLUID_MIXING_TYPE.get(), (RecipeInput)this.getCraftingInv(), this.level).stream().filter(a -> ((FluidMixingRecipe)a.value()).getEntry().equals((Object)DataDrive.getEntryId(this.dataDriveHandler.getStackInSlot(0)))).findFirst();
        if (recipe.isPresent()) {
            if (!((FluidMixingRecipe)recipe.get().value()).equals(this.recipe)) {
                this.workTime = 0;
            }
            if (this.dataDriveHandler.getStackInSlot(0).has(DataComponentRegistry.DATA_ID) && this.dataDriveHandler.getStackInSlot(0).has(DataComponentRegistry.DATA_INCOMPLETE)) {
                if (((FluidMixingRecipe)recipe.get().value()).getEntry().equals((Object)DataDrive.getEntryId(this.dataDriveHandler.getStackInSlot(0))) && DataDrive.getEntryCompletionStage(this.dataDriveHandler.getStackInSlot(0)) >= ((FluidMixingRecipe)recipe.get().value()).getCompletionStage()) {
                    this.recipe = (FluidMixingRecipe)recipe.get().value();
                    this.essenceCost = ((FluidMixingRecipe)recipe.get().value()).getEssenceCost();
                } else {
                    this.recipe = null;
                }
            } else {
                this.recipe = null;
            }
        } else {
            this.recipe = null;
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, FluidMixerBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)pBlockEntity, EssenceTypeRegistry.ESSENCE.get());
            BufferUtil.getItemsFromBuffersBelow(pBlockEntity, (IItemHandler)pBlockEntity.itemHandler);
            BufferUtil.getFluidsFromBuffersBelow(pBlockEntity, pBlockEntity.fluidHandler);
            boolean resetWorkTime = true;
            if (pBlockEntity.recipe != null) {
                FluidStack result;
                boolean enoughEssence = false;
                if (pBlockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) >= pBlockEntity.essenceCost / (float)pBlockEntity.recipe.getTime()) {
                    enoughEssence = true;
                }
                pBlockEntity.enoughEssence = enoughEssence;
                if (enoughEssence && pBlockEntity.outputFluidHandler.fill(result = pBlockEntity.recipe.getOutput(), IFluidHandler.FluidAction.SIMULATE) >= result.getAmount()) {
                    resetWorkTime = false;
                    ++pBlockEntity.workTime;
                    pBlockEntity.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), pBlockEntity.essenceCost / (float)pBlockEntity.recipe.getTime());
                    if (pBlockEntity.workTime >= pBlockEntity.recipe.getTime()) {
                        FluidStack input1 = pBlockEntity.recipe.getInput1();
                        FluidStack input2 = pBlockEntity.recipe.getInput2();
                        pBlockEntity.outputFluidHandler.fill(result, IFluidHandler.FluidAction.EXECUTE);
                        pBlockEntity.itemHandler.extractItem(0, 1, false);
                        pBlockEntity.fluidHandler.drain(input1, IFluidHandler.FluidAction.EXECUTE);
                        pBlockEntity.fluidHandler.drain(input2, IFluidHandler.FluidAction.EXECUTE);
                        pBlockEntity.workTime = 0;
                    }
                }
            }
            if (resetWorkTime) {
                pBlockEntity.workTime = -1;
            }
            pBlockEntity.updateBlock();
        } else {
            Optional recipe = pLevel.getRecipeManager().getRecipeFor(RecipeRegistry.FLUID_MIXING_TYPE.get(), (RecipeInput)pBlockEntity.getCraftingInv(), pLevel);
            recipe.ifPresentOrElse(recipeHolder -> {
                pBlockEntity.recipe = (FluidMixingRecipe)recipeHolder.value();
            }, () -> {
                pBlockEntity.recipe = null;
            });
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new FluidMixerMenu(pContainerId, pInventory, this);
    }
}

