/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.processing;

import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.recipe.EntropicProcessingRecipe;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.DamageTypeRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.screen.EntropicProcessorMenu;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntropicProcessorBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity {
    public DatabankAnimationState animState = new DatabankAnimationState("idle").addAnim(new DatabankAnimationReference("idle", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("working", (state, anim) -> {}, (state, anim) -> {}));
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            EntropicProcessorBlockEntity.this.setChanged();
            EntropicProcessorBlockEntity.this.checkRecipes();
        }
    };
    private final ItemStackHandler outputItemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            EntropicProcessorBlockEntity.this.setChanged();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.outputItemHandler});
    public ItemStack item;
    public float maxTime;
    public int workTime;
    public EntropicProcessingRecipe recipe;
    public float essenceCost;
    private ClientHandler clientHandler;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.animState.setLevel(level);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputItemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public EntropicProcessorBlockEntity(BlockPos pos, BlockState state2) {
        super(BlockEntityRegistry.ENTROPIC_PROCESSOR.get(), pos, state2);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide) {
            this.clientHandler = new ClientHandler();
            this.clientHandler.createWorkingSound(this.getBlockPos());
        } else {
            this.checkRecipes();
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.workTime = tag.getInt("workTime");
        this.maxTime = tag.getInt("maxTime");
        this.item = tag.contains("item") ? ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound("item")) : null;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        tag.putInt("maxTime", this.recipe == null ? -1 : this.recipe.getTime());
        if (this.item != null) {
            tag.put("item", this.item.saveOptional(pRegistries));
        }
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("input", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("output", (Tag)this.outputItemHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("input"));
        this.outputItemHandler.deserializeNBT(pRegistries, nbt.getCompound("output"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.workTime = nbt.getInt("workTime");
    }

    public SimpleContainer getInv() {
        int i;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + this.outputItemHandler.getSlots());
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.outputItemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.itemHandler.getSlots(), this.outputItemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public RecipeInput getCraftingInv() {
        SingleRecipeInput inventory = new SingleRecipeInput(this.itemHandler.getStackInSlot(0));
        return inventory;
    }

    public void checkRecipes() {
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeRegistry.ENTROPIC_PROCESSING_TYPE.get(), this.getCraftingInv(), this.level);
        if (recipe.isPresent()) {
            if (!((EntropicProcessingRecipe)((RecipeHolder)recipe.get()).value()).equals(this.recipe)) {
                this.workTime = 0;
            }
            this.recipe = (EntropicProcessingRecipe)((RecipeHolder)recipe.get()).value();
        } else {
            this.recipe = null;
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, EntropicProcessorBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            ItemStack assembled;
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)pBlockEntity, EssenceTypeRegistry.ESSENCE.get());
            BufferUtil.getItemsFromBuffersBelow(pBlockEntity, (IItemHandler)pBlockEntity.itemHandler);
            boolean resetWorkTime = true;
            if (pBlockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) >= 1.0f && pBlockEntity.recipe != null && pBlockEntity.outputItemHandler.insertItem(0, assembled = pBlockEntity.recipe.assemble(pBlockEntity.getCraftingInv(), (HolderLookup.Provider)pLevel.registryAccess()), true).isEmpty()) {
                for (LivingEntity victim : pLevel.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)pPos.getCenter(), (double)0.9f, (double)0.9f, (double)0.9f))) {
                    victim.hurt(victim.damageSources().source(DamageTypeRegistry.crushed), 2.0f);
                }
                resetWorkTime = false;
                ++pBlockEntity.workTime;
                pBlockEntity.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), 1.0f);
                if (pBlockEntity.workTime >= pBlockEntity.recipe.getTime()) {
                    pBlockEntity.outputItemHandler.insertItem(0, assembled, false);
                    pBlockEntity.itemHandler.extractItem(0, 1, false);
                    pBlockEntity.workTime = 0;
                }
            }
            if (resetWorkTime) {
                pBlockEntity.workTime = -1;
            }
            pBlockEntity.item = pBlockEntity.itemHandler.getStackInSlot(0);
            pBlockEntity.updateBlock();
        } else if (pBlockEntity.workTime >= 0) {
            if (!pBlockEntity.clientHandler.isSoundPlaying()) {
                pBlockEntity.clientHandler.startSound();
            }
            if (pBlockEntity.item != null && !pBlockEntity.item.isEmpty()) {
                Vec3 particlePos = pPos.getCenter().add(0.0, 0.25, 0.0);
                Vec3 particleSpeed = Vec3.directionFromRotation((float)0.0f, (float)pLevel.getRandom().nextIntBetweenInclusive(-180, 180)).scale(0.1).add(0.0, 0.25, 0.0);
                pLevel.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, pBlockEntity.item), particlePos.x, particlePos.y, particlePos.z, particleSpeed.x, particleSpeed.y, particleSpeed.z);
            }
        } else if (pBlockEntity.clientHandler.isSoundPlaying()) {
            pBlockEntity.clientHandler.stopSound();
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new EntropicProcessorMenu(pContainerId, pInventory, this);
    }

    private static boolean hasNotReachedStackLimit(EntropicProcessorBlockEntity entity, ItemStack toAdd) {
        if (toAdd.is(entity.outputItemHandler.getStackInSlot(0).getItem())) {
            return entity.outputItemHandler.getStackInSlot(0).getCount() + toAdd.getCount() <= entity.outputItemHandler.getStackInSlot(0).getMaxStackSize();
        }
        return entity.outputItemHandler.getStackInSlot(0).isEmpty();
    }

    private static class ClientHandler {
        public SoundInstance workingSound;

        private ClientHandler() {
        }

        public void createWorkingSound(BlockPos pos) {
            this.workingSound = new SimpleSoundInstance((SoundEvent)SoundRegistry.ENTROPIC_PROCESSOR_WORKING.value(), SoundSource.BLOCKS, 0.5f, 1.25f, SoundInstance.createUnseededRandom(), pos);
        }

        public void startSound() {
            Minecraft.getInstance().getSoundManager().play(this.workingSound);
        }

        public void stopSound() {
            Minecraft.getInstance().getSoundManager().stop(this.workingSound);
        }

        public boolean isSoundPlaying() {
            return Minecraft.getInstance().getSoundManager().isActive(this.workingSound);
        }
    }
}

