/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.processing;

import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.LockableItemHandler;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.api.essence.container.MultiEssenceContainer;
import com.cmdpro.datanessence.api.misc.ILockableContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.client.FactorySong;
import com.cmdpro.datanessence.item.DataDrive;
import com.cmdpro.datanessence.recipe.IFabricationRecipe;
import com.cmdpro.datanessence.recipe.IHasRequiredKnowledge;
import com.cmdpro.datanessence.recipe.NonMenuCraftingContainer;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.screen.AutoFabricatorMenu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoFabricatorBlockEntity
extends BlockEntity
implements MenuProvider,
ILockableContainer,
EssenceBlockEntity {
    public DatabankAnimationState animState = new DatabankAnimationState("idle").addAnim(new DatabankAnimationReference("idle", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("crafting", (state, anim) -> {}, (state, anim) -> {}));
    private final LockableItemHandler itemHandler = new LockableItemHandler(9){

        protected void onContentsChanged(int slot) {
            AutoFabricatorBlockEntity.this.setChanged();
            AutoFabricatorBlockEntity.this.checkRecipes();
        }

        @Override
        public void setLockedSlots() {
            super.setLockedSlots();
            AutoFabricatorBlockEntity.this.setChanged();
        }

        @Override
        public void setLocked(boolean locked) {
            super.setLocked(locked);
            AutoFabricatorBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return super.isItemValid(slot, stack);
        }
    };
    private final ItemStackHandler dataDriveHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            AutoFabricatorBlockEntity.this.setChanged();
            AutoFabricatorBlockEntity.this.checkRecipes();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.getItem() instanceof DataDrive;
        }
    };
    private final ItemStackHandler outputItemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            AutoFabricatorBlockEntity.this.setChanged();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.dataDriveHandler, this.outputItemHandler});
    public ItemStack item;
    public Recipe<CraftingInput> recipe;
    public boolean enoughEssence;
    public Map<ResourceLocation, Float> essenceCost;
    public int craftingProgress;
    public int maxTime;
    public MultiEssenceContainer storage = new MultiEssenceContainer(List.of(EssenceTypeRegistry.ESSENCE.get(), EssenceTypeRegistry.LUNAR_ESSENCE.get(), EssenceTypeRegistry.NATURAL_ESSENCE.get(), EssenceTypeRegistry.EXOTIC_ESSENCE.get()), 1000.0f);

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        this.animState.setLevel(level);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getDataDriveHandler() {
        return this.dataDriveHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputItemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public AutoFabricatorBlockEntity(BlockPos pos, BlockState state2) {
        super(BlockEntityRegistry.AUTO_FABRICATOR.get(), pos, state2);
        this.item = ItemStack.EMPTY;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.item = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound("item"));
        this.craftingProgress = tag.getInt("craftingProgress");
        this.itemHandler.deserializeNBT(pRegistries, tag.getCompound("itemHandler"));
        this.maxTime = tag.getInt("maxTime");
        if (tag.contains("essenceCost")) {
            CompoundTag cost = tag.getCompound("essenceCost");
            this.essenceCost = new HashMap<ResourceLocation, Float>();
            for (String i : cost.getAllKeys()) {
                ResourceLocation location = ResourceLocation.tryParse((String)i);
                this.essenceCost.put(location, Float.valueOf(cost.getFloat(i)));
            }
        } else {
            this.essenceCost = null;
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.put("item", this.item.saveOptional(pRegistries));
        tag.putInt("craftingProgress", this.craftingProgress);
        tag.put("itemHandler", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.putInt("maxTime", this.maxTime);
        if (this.essenceCost != null) {
            CompoundTag cost = new CompoundTag();
            for (Map.Entry<ResourceLocation, Float> i : this.essenceCost.entrySet()) {
                cost.putFloat(i.getKey().toString(), i.getValue().floatValue());
            }
            tag.put("essenceCost", (Tag)cost);
        }
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("inventoryOutput", (Tag)this.outputItemHandler.serializeNBT(pRegistries));
        tag.put("inventoryDrive", (Tag)this.dataDriveHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("craftingProgress", this.craftingProgress);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
        this.outputItemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventoryOutput"));
        this.dataDriveHandler.deserializeNBT(pRegistries, nbt.getCompound("inventoryDrive"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.craftingProgress = nbt.getInt("craftingProgress");
    }

    public SimpleContainer getInv() {
        int i;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + this.outputItemHandler.getSlots() + this.dataDriveHandler.getSlots());
        for (i = 0; i < this.dataDriveHandler.getSlots(); ++i) {
            inventory.setItem(i, this.dataDriveHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.dataDriveHandler.getSlots(), this.itemHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.outputItemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.dataDriveHandler.getSlots() + this.itemHandler.getSlots(), this.outputItemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public CraftingContainer getCraftingInv() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            items.add(this.itemHandler.getStackInSlot(i));
        }
        NonMenuCraftingContainer inventory = new NonMenuCraftingContainer(items, 3, 3);
        return inventory;
    }

    public boolean tryCraft() {
        Recipe<CraftingInput> recipe = this.recipe;
        if (recipe instanceof IHasRequiredKnowledge) {
            IHasRequiredKnowledge recipe2 = (IHasRequiredKnowledge)recipe;
            if (this.dataDriveHandler.getStackInSlot(0).has(DataComponentRegistry.DATA_ID) && this.dataDriveHandler.getStackInSlot(0).has(DataComponentRegistry.DATA_INCOMPLETE)) {
                if (recipe2.getEntry().equals((Object)DataDrive.getEntryId(this.dataDriveHandler.getStackInSlot(0)))) {
                    if (DataDrive.getEntryCompletionStage(this.dataDriveHandler.getStackInSlot(0)) < recipe2.getCompletionStage()) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        CraftingInput craftingInput = this.getCraftingInv().asCraftInput();
        ItemStack stack = this.recipe.assemble((RecipeInput)craftingInput, (HolderLookup.Provider)this.level.registryAccess()).copy();
        if (!this.recipe.matches((RecipeInput)craftingInput, this.level)) {
            return false;
        }
        NonNullList remaining = this.recipe.getRemainingItems((RecipeInput)craftingInput);
        int left = this.getCraftingInv().asPositionedCraftInput().left();
        int top = this.getCraftingInv().asPositionedCraftInput().top();
        int craftWidth = 3;
        for (int k = 0; k < craftingInput.height(); ++k) {
            for (int l = 0; l < craftingInput.width(); ++l) {
                int i1 = l + left + (k + top) * craftWidth;
                ItemStack itemstack = this.itemHandler.getStackInSlot(i1);
                ItemStack remainderItemstack = (ItemStack)remaining.get(l + k * craftingInput.width());
                if (!itemstack.isEmpty()) {
                    this.itemHandler.extractItem(i1, 1, false);
                    itemstack = this.itemHandler.getStackInSlot(i1);
                }
                if (remainderItemstack.isEmpty()) continue;
                ItemEntity entity = new ItemEntity(this.level, (double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 1.0f), (double)((float)this.getBlockPos().getZ() + 0.5f), remainderItemstack);
                this.level.addFreshEntity((Entity)entity);
            }
        }
        this.outputItemHandler.insertItem(0, stack, false);
        this.level.playSound(null, this.worldPosition, (SoundEvent)SoundRegistry.AUTO_FABRICATOR_CRAFT.value(), SoundSource.BLOCKS, 2.0f, 1.0f);
        return true;
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<RecipeHolder<T>> getRecipeFor(RecipeType<T> type, Level level, I input) {
        return level.getRecipeManager().getRecipesFor(type, input, level).stream().filter(a -> {
            Recipe patt0$temp = a.value();
            if (patt0$temp instanceof IHasRequiredKnowledge) {
                IHasRequiredKnowledge recipe = (IHasRequiredKnowledge)patt0$temp;
                return recipe.getEntry().equals((Object)DataDrive.getEntryId(this.dataDriveHandler.getStackInSlot(0)));
            }
            return true;
        }).findFirst();
    }

    public void checkRecipes() {
        Optional<RecipeHolder<IFabricationRecipe>> fabricationRecipe = this.getRecipeFor(RecipeRegistry.FABRICATIONCRAFTING.get(), this.level, this.getCraftingInv().asCraftInput());
        Recipe recipe = null;
        if (fabricationRecipe.isEmpty()) {
            Optional vanillaRecipe = this.getRecipeFor(RecipeType.CRAFTING, this.level, this.getCraftingInv().asCraftInput());
            if (vanillaRecipe.isPresent()) {
                recipe = vanillaRecipe.get().value();
            }
        } else {
            recipe = fabricationRecipe.get().value();
        }
        if (recipe != null) {
            this.recipe = recipe;
            if (recipe instanceof IFabricationRecipe) {
                IFabricationRecipe recipe2 = (IFabricationRecipe)recipe;
                this.essenceCost = recipe2.getEssenceCost();
                this.maxTime = recipe2.getTime();
            } else {
                this.essenceCost = new HashMap<ResourceLocation, Float>();
                this.maxTime = 20;
            }
            this.item = recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess());
        } else {
            this.recipe = null;
            this.essenceCost = null;
            this.item = ItemStack.EMPTY;
            this.maxTime = 20;
        }
    }

    public void onLoad() {
        super.onLoad();
        if (!this.level.isClientSide) {
            this.checkRecipes();
        }
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, AutoFabricatorBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)pBlockEntity, List.of(EssenceTypeRegistry.ESSENCE.get(), EssenceTypeRegistry.LUNAR_ESSENCE.get(), EssenceTypeRegistry.NATURAL_ESSENCE.get(), EssenceTypeRegistry.EXOTIC_ESSENCE.get()));
            for (LockableItemHandler lockedSlot : pBlockEntity.getLockable()) {
                if (lockedSlot.locked) continue;
                return;
            }
            BufferUtil.getItemsFromBuffersBelow(pBlockEntity, (IItemHandler)pBlockEntity.itemHandler);
            if (pBlockEntity.recipe != null && AutoFabricatorBlockEntity.hasNotReachedStackLimit(pBlockEntity, pBlockEntity.recipe.getResultItem((HolderLookup.Provider)pLevel.registryAccess()))) {
                EssenceType type;
                boolean enoughEssence = true;
                for (Map.Entry<ResourceLocation, Float> i : pBlockEntity.essenceCost.entrySet()) {
                    type = (EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(i.getKey());
                    if (!(pBlockEntity.storage.getEssence(type) < i.getValue().floatValue())) continue;
                    enoughEssence = false;
                }
                pBlockEntity.enoughEssence = enoughEssence;
                if (pBlockEntity.recipe.matches((RecipeInput)pBlockEntity.getCraftingInv().asCraftInput(), pBlockEntity.level)) {
                    ++pBlockEntity.craftingProgress;
                    for (Map.Entry<ResourceLocation, Float> i : pBlockEntity.essenceCost.entrySet()) {
                        type = (EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(i.getKey());
                        pBlockEntity.storage.removeEssence(type, i.getValue().floatValue() / (float)pBlockEntity.maxTime);
                    }
                } else {
                    pBlockEntity.craftingProgress = -1;
                }
            } else {
                pBlockEntity.craftingProgress = -1;
            }
            if (pBlockEntity.craftingProgress >= pBlockEntity.maxTime) {
                pBlockEntity.tryCraft();
                pBlockEntity.craftingProgress = 0;
            }
            pBlockEntity.updateBlock();
        } else if (pBlockEntity.craftingProgress >= 0 && pBlockEntity.essenceCost != null && pBlockEntity.essenceCost.containsKey(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)EssenceTypeRegistry.ESSENCE.get()))) {
            ClientHandler.markIndustrialFactorySong(pPos);
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    private static boolean hasNotReachedStackLimit(AutoFabricatorBlockEntity entity, ItemStack toAdd) {
        if (toAdd.is(entity.outputItemHandler.getStackInSlot(0).getItem())) {
            return entity.outputItemHandler.getStackInSlot(0).getCount() + toAdd.getCount() <= entity.outputItemHandler.getStackInSlot(0).getMaxStackSize();
        }
        return entity.outputItemHandler.getStackInSlot(0).isEmpty();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new AutoFabricatorMenu(pContainerId, pInventory, this);
    }

    @Override
    public List<LockableItemHandler> getLockable() {
        return List.of(this.itemHandler);
    }

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    private static class ClientHandler {
        static FactorySong.FactoryLoop industrialSound = FactorySong.getLoop((SoundEvent)SoundRegistry.AUTO_FABRICATOR_LOOP_INDUSTRIAL.value());

        private ClientHandler() {
        }

        public static void markIndustrialFactorySong(BlockPos pos) {
            industrialSound.addSource(pos);
        }
    }
}

