/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.generation;

import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.client.FactorySong;
import com.cmdpro.datanessence.datamaps.DataNEssenceDatamaps;
import com.cmdpro.datanessence.datamaps.PlantSiphonEssenceMap;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.screen.IndustrialPlantSiphonMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndustrialPlantSiphonBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity {
    public DatabankAnimationState animState = new DatabankAnimationState("idle").addAnim(new DatabankAnimationReference("idle", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("working", (state, anim) -> {}, (state, anim) -> {}));
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    public float essenceGenerationTicks;
    public float generationRate;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            IndustrialPlantSiphonBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 0) {
                return stack.getItemHolder().getData(DataNEssenceDatamaps.PLANT_SIPHON_ESSENCE) != null;
            }
            return super.isItemValid(slot, stack);
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler});

    public void setLevel(Level level) {
        super.setLevel(level);
        this.animState.setLevel(level);
    }

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IndustrialPlantSiphonBlockEntity(BlockPos pos, BlockState state2) {
        super(BlockEntityRegistry.INDUSTRIAL_PLANT_SIPHON.get(), pos, state2);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.essenceGenerationTicks = tag.getFloat("EssenceGenerationTicks");
        this.generationRate = tag.getFloat("GenerationRate");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putFloat("EssenceGenerationTicks", this.essenceGenerationTicks);
        tag.putFloat("GenerationRate", this.generationRate);
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putFloat("EssenceGenerationTicks", this.essenceGenerationTicks);
        tag.putFloat("GenerationRate", this.generationRate);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.essenceGenerationTicks = nbt.getFloat("EssenceGenerationTicks");
        this.generationRate = nbt.getFloat("GenerationRate");
    }

    public SimpleContainer getInv() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public static void tick(Level world, BlockPos pos, BlockState state, IndustrialPlantSiphonBlockEntity tile) {
        if (!world.isClientSide()) {
            BufferUtil.getItemsFromBuffersBelow(tile, (IItemHandler)tile.itemHandler);
            if (tile.essenceGenerationTicks > 0.0f && !(tile.storage.getEssence(EssenceTypeRegistry.ESSENCE.get()) + tile.generationRate > tile.storage.getMaxEssence())) {
                tile.storage.addEssence(EssenceTypeRegistry.ESSENCE.get(), tile.generationRate);
                tile.essenceGenerationTicks -= 1.0f;
            }
            if (tile.essenceGenerationTicks <= 0.0f) {
                tile.essenceGenerationTicks = tile.getGenerationTicks(tile);
                tile.generationRate = tile.getEssenceProduced(tile);
                tile.itemHandler.extractItem(0, 1, false);
            }
            tile.updateBlock();
        } else if (tile.essenceGenerationTicks > 0.0f && !(tile.storage.getEssence(EssenceTypeRegistry.ESSENCE.get()) + tile.generationRate > tile.storage.getMaxEssence())) {
            ClientHandler.markFactorySong(pos);
        }
    }

    public float getGenerationTicks(IndustrialPlantSiphonBlockEntity tile) {
        PlantSiphonEssenceMap map = (PlantSiphonEssenceMap)tile.itemHandler.getStackInSlot(0).getItemHolder().getData(DataNEssenceDatamaps.PLANT_SIPHON_ESSENCE);
        if (map != null) {
            return map.ticks();
        }
        return 0.0f;
    }

    public float getEssenceProduced(IndustrialPlantSiphonBlockEntity tile) {
        PlantSiphonEssenceMap map = (PlantSiphonEssenceMap)tile.itemHandler.getStackInSlot(0).getItemHolder().getData(DataNEssenceDatamaps.PLANT_SIPHON_ESSENCE);
        if (map != null) {
            return map.amountPerTick();
        }
        return 0.0f;
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new IndustrialPlantSiphonMenu(pContainerId, pInventory, this);
    }

    private static class ClientHandler {
        static FactorySong.FactoryLoop workingSound = FactorySong.getLoop((SoundEvent)SoundRegistry.PLANT_SIPHON_LOOP.value());

        private ClientHandler() {
        }

        public static void markFactorySong(BlockPos pos) {
            workingSound.addSource(pos);
        }
    }
}

