/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.generation;

import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.client.FactorySong;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.DamageTypeRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EssenceLeechBlockEntity
extends BlockEntity
implements EssenceBlockEntity {
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    public int cooldown;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public EssenceLeechBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.ESSENCE_LEECH.get(), pos, state);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putInt("cooldown", this.cooldown);
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.cooldown = nbt.getInt("cooldown");
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, EssenceLeechBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide) {
            if (pBlockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) < pBlockEntity.getStorage().getMaxEssence() && pBlockEntity.cooldown <= 0) {
                for (LivingEntity i : pLevel.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)pPos.getCenter().add(0.0, 2.0, 0.0), (double)3.0, (double)3.0, (double)3.0))) {
                    if (!i.isAlive()) continue;
                    i.hurt(i.damageSources().source(DamageTypeRegistry.essenceSiphoned), 5.0f);
                    if (i.isAlive()) continue;
                    pBlockEntity.getStorage().addEssence(EssenceTypeRegistry.ESSENCE.get(), Math.clamp(i.getMaxHealth() * 5.0f, 0.0f, 100.0f));
                }
                pBlockEntity.cooldown = 10;
            } else {
                --pBlockEntity.cooldown;
            }
        } else {
            ClientHandler.markFactorySong(pPos);
        }
    }

    public void onLoad() {
        super.onLoad();
    }

    private static class ClientHandler {
        static FactorySong.FactoryLoop workingSound = FactorySong.getLoop((SoundEvent)SoundRegistry.LEECH_LOOP.value());

        private ClientHandler() {
        }

        public static void markFactorySong(BlockPos pos) {
            workingSound.addSource(pos);
        }
    }
}

