/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.decoration;

import com.cmdpro.datanessence.client.particle.CircleParticleOptions;
import com.cmdpro.datanessence.client.particle.MoteParticleOptions;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Dewlamp
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public Dewlamp(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(Direction.UP), (Direction)Direction.UP);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        float hue = Mth.nextFloat((RandomSource)random, (float)0.0f, (float)1.0f);
        int lifetime = random.nextIntBetweenInclusive(60, 180);
        Color color = new Color(Color.HSBtoRGB(hue, 0.8f, 1.0f));
        double d0 = 0.2;
        float horizontalVelocity = random.nextFloat() * 0.02f;
        horizontalVelocity = random.nextInt() % 2 == 0 ? horizontalVelocity : -horizontalVelocity;
        world.addParticle((ParticleOptions)new CircleParticleOptions().setColor(color).setAdditive(true), true, pos.getCenter().x, pos.getCenter().y + 0.15, pos.getCenter().z, 0.0, 0.0, 0.0);
        for (Direction direction : Direction.values()) {
            BlockPos blockpos = pos.relative(direction);
            if (world.getBlockState(blockpos).isSolidRender((BlockGetter)world, blockpos) || direction == Direction.UP || direction == Direction.DOWN) continue;
            Direction.Axis axis = direction.getAxis();
            double d1 = axis == Direction.Axis.X ? 0.5 + d0 * (double)direction.getStepX() : (double)random.nextFloat();
            double d2 = axis == Direction.Axis.Y ? 0.5 + d0 * (double)direction.getStepY() : (double)random.nextFloat();
            double d3 = axis == Direction.Axis.Z ? 0.5 + d0 * (double)direction.getStepZ() : (double)random.nextFloat();
            world.addParticle((ParticleOptions)new MoteParticleOptions().setColor(color).setAdditive(true).setLifetime(lifetime).setFriction(1.0f).setGravity(0.04f).setPhysics(true), (double)pos.getX() + d1, (double)pos.getY() + d2, (double)pos.getZ() + d3, (double)horizontalVelocity, 0.0, (double)horizontalVelocity);
        }
    }
}

