/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.auxiliary;

import com.cmdpro.datanessence.client.particle.MoteParticleOptions;
import com.cmdpro.datanessence.client.particle.RhombusParticleOptions;
import com.cmdpro.datanessence.client.particle.SmallCircleParticleOptions;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class VacuumBlockEntity
extends BlockEntity {
    public VacuumBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.VACUUM.get(), pPos, pBlockState);
    }

    public static void tick(Level world, BlockPos pos, BlockState pState, VacuumBlockEntity pBlockEntity) {
        if (!world.isClientSide) {
            List itemsBeingSuckedUp = world.getEntitiesOfClass(ItemEntity.class, AABB.ofSize((Vec3)pos.getCenter(), (double)20.0, (double)20.0, (double)20.0));
            for (ItemEntity i : itemsBeingSuckedUp) {
                i.setDeltaMovement(pos.getCenter().subtract(i.position()).normalize().multiply(0.2, 0.2, 0.2));
                i.hasImpulse = true;
            }
            List itemsBeingCollected = world.getEntitiesOfClass(ItemEntity.class, AABB.ofSize((Vec3)pos.getCenter(), (double)3.0, (double)3.0, (double)3.0));
            IItemHandler itemHandler = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos.above(), (Object)Direction.DOWN);
            if (itemHandler != null) {
                boolean collectedSomething = false;
                for (ItemEntity i : itemsBeingCollected) {
                    ItemStack copy = i.getItem().copy();
                    if (!copy.isEmpty()) {
                        for (int o = 0; o < itemHandler.getSlots(); ++o) {
                            ItemStack stack = itemHandler.getStackInSlot(o);
                            if (!stack.is(copy.getItem()) && !stack.isEmpty()) continue;
                            copy = itemHandler.insertItem(o, copy, false);
                            collectedSomething = true;
                        }
                    }
                    i.setItem(copy);
                }
                if (collectedSomething) {
                    world.playSound(null, pos, (SoundEvent)SoundRegistry.VACUUM_PICKUP.value(), SoundSource.BLOCKS, Mth.nextFloat((RandomSource)world.random, (float)0.1f, (float)0.6f), world.random.nextFloat());
                }
            }
        } else {
            Color[] enderColors = new Color[]{new Color(23612), new Color(209704), new Color(26195)};
            Color[] redstoneColors = new Color[]{new Color(15015711), new Color(10290724), new Color(15814194)};
            Vec3 pos1 = pos.getCenter().add((double)Mth.nextFloat((RandomSource)world.random, (float)-0.5f, (float)0.5f), (double)Mth.nextFloat((RandomSource)world.random, (float)-0.5f, (float)0.5f), (double)Mth.nextFloat((RandomSource)world.random, (float)-0.5f, (float)0.5f));
            Vec3 vel1 = pos.getCenter().subtract(pos1).multiply((double)0.4f, (double)0.1f, (double)0.2f);
            Color color1 = enderColors[world.random.nextIntBetweenInclusive(0, enderColors.length - 1)];
            Vec3 pos2 = pos.getCenter().add((double)Mth.nextFloat((RandomSource)world.random, (float)-0.5f, (float)0.5f), (double)Mth.nextFloat((RandomSource)world.random, (float)-0.5f, (float)0.5f), (double)Mth.nextFloat((RandomSource)world.random, (float)-0.5f, (float)0.5f));
            Vec3 vel2 = pos.getCenter().subtract(pos2).multiply((double)0.4f, (double)0.1f, (double)0.2f);
            Color color2 = enderColors[world.random.nextIntBetweenInclusive(0, enderColors.length - 1)];
            Vec3 pos3 = pos.getCenter();
            Vec3 vel3 = pos.getCenter().subtract(pos3).add(0.0, (double)0.08f, 0.0);
            Color color3 = redstoneColors[world.random.nextIntBetweenInclusive(0, redstoneColors.length - 1)];
            world.addParticle((ParticleOptions)new RhombusParticleOptions().setColor(color1), pos1.x, pos1.y, pos1.z, vel1.x, vel1.y, vel1.z);
            world.addParticle((ParticleOptions)new SmallCircleParticleOptions().setColor(color2), pos2.x, pos2.y, pos2.z, vel2.x, vel2.y, vel2.z);
            if (world.random.nextInt() % 3 == 0) {
                world.addParticle((ParticleOptions)new MoteParticleOptions().setColor(color3).setAdditive(true), pos3.x, pos3.y, pos3.z, vel3.x, vel3.y, vel3.z);
            }
        }
    }
}

