/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.auxiliary;

import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.api.item.ILaserEmitterModule;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.block.auxiliary.LaserEmitter;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.screen.LaserEmitterMenu;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaserEmitterBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity {
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    public ItemStack item;
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            LaserEmitterBlockEntity.this.setChanged();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler});
    public Vec3 end;
    public int redstoneLevel;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public SimpleContainer getInv() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public LaserEmitterBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.LASER_EMITTER.get(), pos, state);
        this.item = ItemStack.EMPTY;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.item = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound("item"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.put("item", this.item.saveOptional(pRegistries));
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, LaserEmitterBlockEntity pBlockEntity) {
        int oldRedstoneLevel = pBlockEntity.redstoneLevel;
        boolean updated = false;
        boolean drainsEssence = true;
        if (!(pBlockEntity.itemHandler.getStackInSlot(0).getItem() instanceof ILaserEmitterModule)) {
            drainsEssence = false;
        }
        if (!pLevel.isClientSide) {
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)pBlockEntity, EssenceTypeRegistry.ESSENCE.get());
            pBlockEntity.item = pBlockEntity.itemHandler.getStackInSlot(0).copy();
        }
        if (pBlockEntity.storage.getEssence(EssenceTypeRegistry.ESSENCE.get()) >= 0.5f || !drainsEssence) {
            BlockPos pos;
            float dist = 0.0f;
            for (int i = 1; i <= 10 && !pLevel.getBlockState(pos = pPos.relative((Direction)pState.getValue((Property)LaserEmitter.FACING), i)).isSolid(); ++i) {
                dist = (float)i + 0.5f;
            }
            if (dist > 0.0f) {
                pBlockEntity.end = pPos.getCenter().relative((Direction)pState.getValue((Property)LaserEmitter.FACING), (double)dist);
                if (!pLevel.isClientSide) {
                    if (drainsEssence) {
                        pBlockEntity.storage.removeEssence(EssenceTypeRegistry.ESSENCE.get(), 0.5f);
                    }
                    pBlockEntity.updateBlock();
                    updated = true;
                    AABB bounds = AABB.encapsulatingFullBlocks((BlockPos)pPos, (BlockPos)pPos.relative((Direction)pState.getValue((Property)LaserEmitter.FACING), (int)(dist - 0.5f)));
                    List ents = pLevel.getEntitiesOfClass(LivingEntity.class, bounds);
                    ILaserEmitterModule module = null;
                    Item item = pBlockEntity.itemHandler.getStackInSlot(0).getItem();
                    if (item instanceof ILaserEmitterModule) {
                        ILaserEmitterModule mod;
                        module = mod = (ILaserEmitterModule)item;
                    }
                    for (LivingEntity i : ents) {
                        if (module == null) continue;
                        module.applyToMob(pBlockEntity, i);
                    }
                    pBlockEntity.redstoneLevel = module == null ? (ents.size() > 0 ? 15 : 0) : module.getRedstoneLevel(pBlockEntity, ents);
                } else {
                    pBlockEntity.redstoneLevel = 0;
                }
            } else {
                pBlockEntity.end = null;
                pBlockEntity.redstoneLevel = 0;
            }
        } else {
            pBlockEntity.end = null;
            pBlockEntity.redstoneLevel = 0;
        }
        if (oldRedstoneLevel != pBlockEntity.redstoneLevel && !updated) {
            pBlockEntity.updateBlock();
            updated = true;
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new LaserEmitterMenu(pContainerId, pInventory, this);
    }
}

