/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.auxiliary;

import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.container.SingleEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.screen.FluidBottlerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FluidBottlerBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity {
    public SingleEssenceContainer storage = new SingleEssenceContainer(EssenceTypeRegistry.ESSENCE.get(), 1000.0f);
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            FluidBottlerBlockEntity.this.setChanged();
        }
    };
    private final ItemStackHandler outputItemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            FluidBottlerBlockEntity.this.setChanged();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler, this.outputItemHandler});
    private final FluidTank fluidHandler = new FluidTank(4000);
    public ItemStack item = ItemStack.EMPTY;
    public int workTime;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public IFluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getOutputHandler() {
        return this.outputItemHandler;
    }

    public FluidBottlerBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.FLUID_BOTTLER.get(), pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.workTime = tag.getInt("workTime");
        this.item = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound("item"));
        this.fluidHandler.readFromNBT(pRegistries, tag.getCompound("fluid"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        tag.put("item", this.item.saveOptional(pRegistries));
        tag.put("fluid", (Tag)this.fluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("input", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("output", (Tag)this.outputItemHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("workTime", this.workTime);
        tag.put("fluid", (Tag)this.fluidHandler.writeToNBT(pRegistries, new CompoundTag()));
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("input"));
        this.outputItemHandler.deserializeNBT(pRegistries, nbt.getCompound("output"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.workTime = nbt.getInt("workTime");
        this.fluidHandler.readFromNBT(pRegistries, nbt.getCompound("fluid"));
    }

    public SimpleContainer getInv() {
        int i;
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + this.outputItemHandler.getSlots());
        for (i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        for (i = 0; i < this.outputItemHandler.getSlots(); ++i) {
            inventory.setItem(i + this.itemHandler.getSlots(), this.outputItemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public RecipeInput getCraftingInv() {
        SingleRecipeInput inventory = new SingleRecipeInput(this.itemHandler.getStackInSlot(0));
        return inventory;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, FluidBottlerBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)pBlockEntity, EssenceTypeRegistry.ESSENCE.get());
            BufferUtil.getItemsFromBuffersBelow(pBlockEntity, (IItemHandler)pBlockEntity.itemHandler);
            BufferUtil.getFluidsFromBuffersBelow(pBlockEntity, (IFluidHandler)pBlockEntity.fluidHandler);
            boolean resetWorkTime = true;
            if ((double)pBlockEntity.getStorage().getEssence(EssenceTypeRegistry.ESSENCE.get()) >= 2.5) {
                ItemStack bottle;
                ItemStack bucket;
                ItemStack stack = pBlockEntity.itemHandler.getStackInSlot(0);
                if (stack.is(Items.BUCKET) && pBlockEntity.fluidHandler.getFluid().getAmount() >= 1000 && pBlockEntity.outputItemHandler.insertItem(0, bucket = FluidUtil.getFilledBucket((FluidStack)pBlockEntity.fluidHandler.getFluid()), true).isEmpty()) {
                    ++pBlockEntity.workTime;
                    resetWorkTime = false;
                    pBlockEntity.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), 2.5f);
                    if (pBlockEntity.workTime >= 20) {
                        pBlockEntity.itemHandler.extractItem(0, 1, false);
                        pBlockEntity.outputItemHandler.insertItem(0, bucket, false);
                        pBlockEntity.fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                        pBlockEntity.workTime = 0;
                        pLevel.playSound(null, pPos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
                if (stack.is(Items.GLASS_BOTTLE) && pBlockEntity.fluidHandler.getFluid().getAmount() >= 250 && pBlockEntity.fluidHandler.getFluid().is((Fluid)Fluids.WATER) && pBlockEntity.outputItemHandler.insertItem(0, bottle = PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER), true).isEmpty()) {
                    ++pBlockEntity.workTime;
                    resetWorkTime = false;
                    pBlockEntity.getStorage().removeEssence(EssenceTypeRegistry.ESSENCE.get(), 2.5f);
                    if (pBlockEntity.workTime >= 20) {
                        pBlockEntity.itemHandler.extractItem(0, 1, false);
                        pBlockEntity.outputItemHandler.insertItem(0, bottle, false);
                        pBlockEntity.fluidHandler.drain(250, IFluidHandler.FluidAction.EXECUTE);
                        pBlockEntity.workTime = 0;
                        pLevel.playSound(null, pPos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
            if (resetWorkTime) {
                pBlockEntity.workTime = -1;
            }
            pBlockEntity.updateBlock();
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new FluidBottlerMenu(pContainerId, pInventory, this);
    }

    private static boolean hasNotReachedStackLimit(FluidBottlerBlockEntity entity, ItemStack toAdd) {
        if (toAdd.is(entity.outputItemHandler.getStackInSlot(0).getItem())) {
            return entity.outputItemHandler.getStackInSlot(0).getCount() + toAdd.getCount() <= entity.outputItemHandler.getStackInSlot(0).getMaxStackSize();
        }
        return entity.outputItemHandler.getStackInSlot(0).isEmpty();
    }
}

