/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.auxiliary;

import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.api.essence.container.MultiEssenceContainer;
import com.cmdpro.datanessence.api.item.ItemEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.registry.EssenceTypeRegistry;
import com.cmdpro.datanessence.screen.ChargerMenu;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChargerBlockEntity
extends BlockEntity
implements MenuProvider,
EssenceBlockEntity {
    public DatabankAnimationState animState = new DatabankAnimationState("idle_empty").addAnim(new DatabankAnimationReference("idle_empty", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("orb_spin", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("orb_rise", (state, anim) -> {}, (state, anim) -> state.setAnim("orb_spin"))).addAnim(new DatabankAnimationReference("extend_exciters", (state, anim) -> {}, (state, anim) -> state.setAnim("idle_exciters_out"))).addAnim(new DatabankAnimationReference("retract_exciters", (state, anim) -> {}, (state, anim) -> state.setAnim("idle_empty"))).addAnim(new DatabankAnimationReference("idle_exciters_out", (state, anim) -> {}, (state, anim) -> {})).addAnim(new DatabankAnimationReference("orb_fall", (state, anim) -> {}, (state, anim) -> state.setAnim("idle_exciters_out")));
    public MultiEssenceContainer storage = new MultiEssenceContainer(List.of(EssenceTypeRegistry.ESSENCE.get(), EssenceTypeRegistry.LUNAR_ESSENCE.get(), EssenceTypeRegistry.NATURAL_ESSENCE.get(), EssenceTypeRegistry.EXOTIC_ESSENCE.get()), 1000.0f);
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            ChargerBlockEntity.this.setChanged();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler});
    public ItemStack item = ItemStack.EMPTY;
    public float essenceCost;
    public float lunarEssenceCost;
    public float naturalEssenceCost;
    public float exoticEssenceCost;
    public boolean charging;

    public void setLevel(Level level) {
        super.setLevel(level);
        this.animState.setLevel(level);
    }

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public ChargerBlockEntity(BlockPos pos, BlockState state2) {
        super(BlockEntityRegistry.CHARGER.get(), pos, state2);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.item = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound("item"));
        this.charging = tag.getBoolean("charging");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.put("item", this.item.saveOptional(pRegistries));
        tag.putBoolean("charging", this.charging);
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
    }

    public SimpleContainer getInv() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, ChargerBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            ItemStack stack;
            pBlockEntity.charging = false;
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)pBlockEntity, List.of(EssenceTypeRegistry.ESSENCE.get(), EssenceTypeRegistry.LUNAR_ESSENCE.get(), EssenceTypeRegistry.NATURAL_ESSENCE.get(), EssenceTypeRegistry.EXOTIC_ESSENCE.get()));
            pBlockEntity.item = stack = pBlockEntity.itemHandler.getStackInSlot(0).copy();
            for (EssenceType i : pBlockEntity.storage.getSupportedEssenceTypes()) {
                float fill;
                float essence;
                ResourceLocation essenceType = DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)i);
                float maxEssence = ItemEssenceContainer.getMaxEssence(stack);
                if (!(maxEssence > 0.0f) || !ItemEssenceContainer.getSupportedEssenceTypes(stack).contains(essenceType) || !((essence = ItemEssenceContainer.getEssence(stack, essenceType)) < maxEssence) || !((fill = Math.min(maxEssence - essence, Math.min(5.0f, pBlockEntity.getStorage().getEssence(i)))) > 0.0f)) continue;
                ItemEssenceContainer.addEssence(stack, essenceType, fill);
                pBlockEntity.getStorage().removeEssence(i, fill);
                pBlockEntity.charging = true;
            }
            pBlockEntity.itemHandler.setStackInSlot(0, stack);
            pBlockEntity.updateBlock();
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new ChargerMenu(pContainerId, pInventory, this);
    }

    @Override
    public float getMeterSideLength(Direction direction) {
        if (!this.charging && direction.equals((Object)Direction.UP)) {
            return -0.25f;
        }
        return EssenceBlockEntity.super.getMeterSideLength(direction);
    }
}

