/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.util.client;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBarBackgroundType;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.moddata.ClientPlayerData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ClientEssenceBarUtil {
    public static void drawEssenceBarTiny(GuiGraphics graphics, int x, int y, EssenceType type, float amount, float full) {
        ClientEssenceBarUtil.drawEssenceBarTiny(graphics, x, y, type, amount, full, null);
    }

    public static void drawEssenceBarTiny(GuiGraphics graphics, int x, int y, EssenceType type, float amount, float full, EssenceBarBackgroundType backgroundType) {
        if (backgroundType != null) {
            graphics.blit(backgroundType.tinyBarSprite.texture, x - 1, y - 1, backgroundType.tinyBarSprite.x, backgroundType.tinyBarSprite.y, 5, 24);
        }
        ResourceLocation fill = type.getTinyBarSprite().texture;
        int u = type.getTinyBarSprite().x;
        int v = type.getTinyBarSprite().y;
        if (amount > 0.0f) {
            graphics.blit(fill, x, y + 22 - (int)Math.ceil(22.0f * (amount / full)), u, v + 22 - (int)Math.ceil(22.0f * (amount / full)), 3, (int)Math.ceil(22.0f * (amount / full)));
        }
    }

    public static Component getEssenceBarTooltipTiny(double mouseX, double mouseY, int x, int y, EssenceType type, float amount) {
        if (amount > 0.0f && mouseX <= (double)(x + 3) && mouseY <= (double)(y + 22) && mouseX >= (double)x && mouseY >= (double)y) {
            if (ClientPlayerData.getUnlockedEssences().getOrDefault(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)type), false).booleanValue()) {
                return Component.translatable((String)type.getTooltipKey(), (Object[])new Object[]{Float.valueOf(amount)});
            }
            return Component.translatable((String)"gui.essence_bar.unknown", (Object[])new Object[]{Float.valueOf(amount)});
        }
        return null;
    }

    public static void drawEssenceBar(GuiGraphics graphics, int x, int y, EssenceType type, float amount, float full) {
        ClientEssenceBarUtil.drawEssenceBar(graphics, x, y, type, amount, full, null);
    }

    public static void drawEssenceBar(GuiGraphics graphics, int x, int y, EssenceType type, float amount, float full, EssenceBarBackgroundType backgroundType) {
        if (backgroundType != null) {
            graphics.blit(backgroundType.bigBarSprite.texture, x - 1, y - 1, backgroundType.bigBarSprite.x, backgroundType.bigBarSprite.y, 9, 54);
        }
        if (amount > 0.0f) {
            ResourceLocation fill = type.getBigBarSprite().texture;
            int u = type.getBigBarSprite().x;
            int v = type.getBigBarSprite().y;
            graphics.blit(fill, x, y + 52 - (int)Math.ceil(52.0f * (amount / full)), u, v + 52 - (int)Math.ceil(52.0f * (amount / full)), 7, (int)Math.ceil(52.0f * (amount / full)));
        }
    }

    public static void drawEssenceIcon(GuiGraphics graphics, int x, int y, EssenceType type) {
        ClientEssenceBarUtil.drawEssenceIcon(graphics, x, y, type, null, false, true);
    }

    public static void drawEssenceIcon(GuiGraphics graphics, int x, int y, EssenceType type, EssenceBarBackgroundType backgroundType, boolean unlocked) {
        ClientEssenceBarUtil.drawEssenceIcon(graphics, x, y, type, backgroundType, true, unlocked);
    }

    public static void drawEssenceIcon(GuiGraphics graphics, int x, int y, EssenceType type, EssenceBarBackgroundType backgroundType, boolean drawBackground, boolean unlocked) {
        if (!unlocked && backgroundType == null) {
            return;
        }
        ResourceLocation texture = type.getIconSprite().texture;
        int u = type.getIconSprite().x;
        int v = type.getIconSprite().y;
        if (!unlocked) {
            texture = backgroundType.unknownIconSprite.texture;
            u = backgroundType.unknownIconSprite.x;
            v = backgroundType.unknownIconSprite.y;
        }
        if (backgroundType != null && drawBackground) {
            graphics.blit(backgroundType.iconSprite.texture, x, y, backgroundType.iconSprite.x, backgroundType.iconSprite.y, 9, 9);
        }
        graphics.blit(texture, x, y, u, v, 9, 9);
    }

    public static Component getEssenceBarTooltip(double mouseX, double mouseY, int x, int y, EssenceType type, float amount) {
        if (amount > 0.0f && mouseX >= (double)x && mouseY >= (double)y && mouseX <= (double)(x + 7) && mouseY <= (double)(y + 52)) {
            if (ClientPlayerData.getUnlockedEssences().getOrDefault(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)type), false).booleanValue()) {
                return Component.translatable((String)type.getTooltipKey(), (Object[])new Object[]{Float.valueOf(amount)});
            }
            return Component.translatable((String)"gui.essence_bar.unknown", (Object[])new Object[]{Float.valueOf(amount)});
        }
        return null;
    }
}

