/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.util;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.api.util.PlayerDataUtil;
import com.cmdpro.datanessence.data.databank.DataBankEntries;
import com.cmdpro.datanessence.data.databank.DataBankEntry;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class DataTabletUtil {
    public static void unlockEntry(Player player, ResourceLocation entry, int incompleteStage) {
        Entry entry2 = Entries.entries.get(entry);
        HashMap incompleteEntries = (HashMap)player.getData(AttachmentTypeRegistry.INCOMPLETE_STAGES);
        List unlocked = (List)player.getData(AttachmentTypeRegistry.UNLOCKED);
        int finalIncompleteStage = incompleteStage;
        if (entry2.isIncomplete(incompleteStage)) {
            int stage;
            for (stage = Math.max(incompleteStage, entry2.getIncompleteStageServer(player)); stage < entry2.completionStages.size(); ++stage) {
                List<ResourceLocation> advancements = entry2.completionStages.get((int)stage).completionAdvancements;
                boolean isUnlocked = true;
                for (ResourceLocation i : advancements) {
                    if (((ServerPlayer)player).getAdvancements().getOrStartProgress(player.getServer().getAdvancements().get(i)).isDone()) continue;
                    isUnlocked = false;
                    break;
                }
                if (!isUnlocked) break;
            }
            finalIncompleteStage = stage;
        }
        if (entry2 != null && entry2.isUnlockedServer(player) && !unlocked.contains(entry)) {
            if (finalIncompleteStage < entry2.completionStages.size()) {
                incompleteEntries.put(entry, finalIncompleteStage);
            } else {
                incompleteEntries.remove(entry);
                unlocked.add(entry);
            }
            PlayerDataUtil.unlockEntry((ServerPlayer)player, entry, finalIncompleteStage);
            DataTabletUtil.checkForTierUpgrades(player);
        }
    }

    public static void removeEntry(Player player, ResourceLocation id) {
        Entry entryToRemove = Entries.entries.get(id);
        List unlockedEntries = (List)player.getData(AttachmentTypeRegistry.UNLOCKED);
        if (entryToRemove != null && entryToRemove.isUnlockedServer(player) && unlockedEntries.contains(id)) {
            unlockedEntries.remove(id);
            PlayerDataUtil.updateUnlockedEntries((ServerPlayer)player);
            DataTabletUtil.checkForTierUpgrades(player);
        }
    }

    public static void unlockEntryAndParents(Player player, ResourceLocation entry, int incompleteStage) {
        Entry entry2 = Entries.entries.get(entry);
        HashMap incompleteEntries = (HashMap)player.getData(AttachmentTypeRegistry.INCOMPLETE_STAGES);
        List unlocked = (List)player.getData(AttachmentTypeRegistry.UNLOCKED);
        int finalIncompleteStage = incompleteStage;
        if (entry2.isIncomplete(incompleteStage)) {
            int stage;
            for (stage = Math.max(incompleteStage, entry2.getIncompleteStageServer(player)); stage < entry2.completionStages.size(); ++stage) {
                List<ResourceLocation> advancements = entry2.completionStages.get((int)stage).completionAdvancements;
                boolean isUnlocked = true;
                for (ResourceLocation i : advancements) {
                    if (((ServerPlayer)player).getAdvancements().getOrStartProgress(player.getServer().getAdvancements().get(i)).isDone()) continue;
                    isUnlocked = false;
                    break;
                }
                if (!isUnlocked) break;
            }
            finalIncompleteStage = stage;
        }
        if (entry2 != null && entry2.isUnlockedServer(player) && !unlocked.contains(entry)) {
            if (finalIncompleteStage < entry2.completionStages.size()) {
                incompleteEntries.put(entry, finalIncompleteStage);
            } else {
                incompleteEntries.remove(entry);
                unlocked.add(entry);
            }
            PlayerDataUtil.unlockEntry((ServerPlayer)player, entry, finalIncompleteStage);
            for (Entry i : entry2.getParentEntries()) {
                DataTabletUtil.unlockEntryAndParents(player, i.id, i.completionStages.size());
            }
        }
        DataTabletUtil.checkForTierUpgrades(player);
    }

    public static boolean playerHasEntry(Player player, ResourceLocation entry, int completionStage) {
        if (entry != null) {
            HashMap incomplete;
            if (((ArrayList)player.getData(AttachmentTypeRegistry.UNLOCKED)).contains(entry)) {
                return true;
            }
            if (completionStage != -1 && (incomplete = (HashMap)player.getData(AttachmentTypeRegistry.INCOMPLETE_STAGES)).containsKey(entry)) {
                return (Integer)incomplete.get(entry) >= completionStage;
            }
        }
        return false;
    }

    public static boolean playerHasEntry(Player player, ResourceLocation entry, boolean allowIncomplete) {
        return DataTabletUtil.playerHasEntry(player, entry, allowIncomplete ? 0 : -1);
    }

    public static int getTier(Player player) {
        return (Integer)player.getData(AttachmentTypeRegistry.TIER);
    }

    public static void setTier(Player player, int tier) {
        player.setData(AttachmentTypeRegistry.TIER, (Object)tier);
        PlayerDataUtil.sendTier((ServerPlayer)player, true);
        List<EssenceType> essenceTypes = DataTabletUtil.getUnlockedTypesForTier(tier);
        boolean anyUnlocked = false;
        for (EssenceType i : essenceTypes) {
            if (((HashMap)player.getData(AttachmentTypeRegistry.UNLOCKED_ESSENCES)).getOrDefault(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)i), false).booleanValue()) continue;
            ((HashMap)player.getData(AttachmentTypeRegistry.UNLOCKED_ESSENCES)).put(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)i), true);
            anyUnlocked = true;
        }
        if (anyUnlocked) {
            PlayerDataUtil.updateData((ServerPlayer)player);
        }
    }

    public static int getMaxTier() {
        int tier = 0;
        for (DataBankEntry i : DataBankEntries.entries.values()) {
            if (i.tier <= tier) continue;
            tier = i.tier;
        }
        return tier;
    }

    public static void checkForTierUpgrades(Player player) {
        int tier = DataTabletUtil.getMaxTier();
        ArrayList unlocked = (ArrayList)player.getData(AttachmentTypeRegistry.UNLOCKED);
        for (Entry i : Entries.entries.values()) {
            Optional<DataBankEntry> entry;
            if (unlocked.contains(i.id) || !i.critical || !(entry = DataBankEntries.entries.values().stream().filter(a -> a.entry.equals((Object)i.id)).findFirst()).isPresent() || tier <= entry.get().tier) continue;
            tier = entry.get().tier;
        }
        if (DataTabletUtil.getTier(player) != tier) {
            DataTabletUtil.setTier(player, tier);
        }
    }

    public static List<EssenceType> getUnlockedTypesForTier(int tier) {
        ArrayList<EssenceType> essenceTypes = new ArrayList<EssenceType>();
        for (EssenceType i : DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.stream().toList()) {
            if (tier < i.tier) continue;
            essenceTypes.add(i);
        }
        return essenceTypes;
    }
}

