/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.util;

import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.block.transmission.EssenceBufferBlockEntity;
import com.cmdpro.datanessence.block.transmission.FluidBufferBlockEntity;
import com.cmdpro.datanessence.block.transmission.ItemBufferBlockEntity;
import com.cmdpro.datanessence.networking.packet.s2c.vfx.PlayBufferTransferParticle;
import com.cmdpro.datanessence.registry.TagRegistry;
import java.awt.Color;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public class BufferUtil {
    public static void getEssenceFromBuffersBelow(BlockEntity container, EssenceType type) {
        for (int i = 1; i <= 5; ++i) {
            EssenceBufferBlockEntity buffer;
            float transferredAmount;
            BlockEntity ent = container.getLevel().getBlockEntity(container.getBlockPos().offset(0, -i, 0));
            if (ent instanceof EssenceBufferBlockEntity && (transferredAmount = EssenceStorage.transferEssence((buffer = (EssenceBufferBlockEntity)ent).getStorage(), ((EssenceBlockEntity)container).getStorage(), type, buffer.getStorage().getMaxEssence())) > 0.0f) {
                PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)buffer.getLevel()), null, (double)buffer.getBlockPos().getX(), (double)buffer.getBlockPos().getY(), (double)buffer.getBlockPos().getZ(), (double)16.0, (CustomPacketPayload)new PlayBufferTransferParticle(buffer.getBlockPos(), new Color(14825199)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (!container.getLevel().getBlockState(container.getBlockPos().offset(0, -i, 0)).is(TagRegistry.Blocks.BUFFER_DETECTION_PASS)) break;
        }
    }

    public static void getEssenceFromBuffersBelow(BlockEntity container, Iterable<EssenceType> types) {
        for (int i = 1; i <= 5; ++i) {
            BlockEntity ent = container.getLevel().getBlockEntity(container.getBlockPos().offset(0, -i, 0));
            if (ent instanceof EssenceBufferBlockEntity) {
                EssenceBufferBlockEntity buffer = (EssenceBufferBlockEntity)ent;
                for (EssenceType o : types) {
                    float transferredAmount = EssenceStorage.transferEssence(buffer.getStorage(), ((EssenceBlockEntity)container).getStorage(), o, buffer.getStorage().getMaxEssence());
                    if (!(transferredAmount > 0.0f)) continue;
                    PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)buffer.getLevel()), null, (double)buffer.getBlockPos().getX(), (double)buffer.getBlockPos().getY(), (double)buffer.getBlockPos().getZ(), (double)16.0, (CustomPacketPayload)new PlayBufferTransferParticle(buffer.getBlockPos(), new Color(14825199)), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (!container.getLevel().getBlockState(container.getBlockPos().offset(0, -i, 0)).is(TagRegistry.Blocks.BUFFER_DETECTION_PASS)) break;
        }
    }

    public static void getItemsFromBuffersBelow(BlockEntity container) {
        BufferUtil.getItemsFromBuffersBelow(container, (IItemHandler)container.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, container.getBlockPos(), (Object)Direction.DOWN));
    }

    public static void getItemsFromBuffersBelow(BlockEntity container, IItemHandler handler) {
        for (int i = 1; i <= 5; ++i) {
            ItemBufferBlockEntity buffer;
            boolean transferredSomething;
            BlockEntity ent = container.getLevel().getBlockEntity(container.getBlockPos().offset(0, -i, 0));
            if (ent instanceof ItemBufferBlockEntity && (transferredSomething = (buffer = (ItemBufferBlockEntity)ent).transfer(handler))) {
                PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)buffer.getLevel()), null, (double)buffer.getBlockPos().getX(), (double)buffer.getBlockPos().getY(), (double)buffer.getBlockPos().getZ(), (double)16.0, (CustomPacketPayload)new PlayBufferTransferParticle(buffer.getBlockPos(), new Color(15682877)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (!container.getLevel().getBlockState(container.getBlockPos().offset(0, -i, 0)).is(TagRegistry.Blocks.BUFFER_DETECTION_PASS)) break;
        }
    }

    public static void getFluidsFromBuffersBelow(BlockEntity container) {
        BufferUtil.getFluidsFromBuffersBelow(container, (IFluidHandler)container.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, container.getBlockPos(), (Object)Direction.DOWN));
    }

    public static void getFluidsFromBuffersBelow(BlockEntity container, IFluidHandler handler) {
        for (int i = 1; i <= 5; ++i) {
            FluidBufferBlockEntity buffer;
            boolean transferredSomething;
            BlockEntity ent = container.getLevel().getBlockEntity(container.getBlockPos().offset(0, -i, 0));
            if (ent instanceof FluidBufferBlockEntity && (transferredSomething = (buffer = (FluidBufferBlockEntity)ent).transfer(handler))) {
                PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)buffer.getLevel()), null, (double)buffer.getBlockPos().getX(), (double)buffer.getBlockPos().getY(), (double)buffer.getBlockPos().getZ(), (double)16.0, (CustomPacketPayload)new PlayBufferTransferParticle(buffer.getBlockPos(), new Color(5683945)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (!container.getLevel().getBlockState(container.getBlockPos().offset(0, -i, 0)).is(TagRegistry.Blocks.BUFFER_DETECTION_PASS)) break;
        }
    }
}

