/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.pearlnetwork;

import com.cmdpro.datanessence.api.misc.BlockPosNetworks;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jgrapht.graph.DefaultEdge;

public class PearlNetworkBlockEntity
extends BlockEntity {
    public List<BlockPos> link = new ArrayList<BlockPos>();

    public PearlNetworkBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public void updateLinks() {
        this.link.clear();
        BlockPosNetworks networks = (BlockPosNetworks)this.level.getData(AttachmentTypeRegistry.ENDER_PEARL_NETWORKS);
        if (networks.graph.containsVertex((Object)this.getBlockPos())) {
            for (DefaultEdge i : networks.graph.edgesOf((Object)this.getBlockPos())) {
                if (!((BlockPos)networks.graph.getEdgeSource((Object)i)).equals((Object)this.getBlockPos())) continue;
                BlockPos target = (BlockPos)networks.graph.getEdgeTarget((Object)i);
                this.link.add(target);
            }
        }
    }

    public Vec3 getLinkShift() {
        return Vec3.ZERO;
    }

    public void updateBlock() {
        this.updateLinks();
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        ListTag list = (ListTag)tag.get("link");
        this.link.clear();
        for (Tag i : list) {
            CompoundTag blockpos = (CompoundTag)i;
            this.link.add(new BlockPos(blockpos.getInt("linkX"), blockpos.getInt("linkY"), blockpos.getInt("linkZ")));
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (BlockPos target : this.link) {
            CompoundTag blockpos = new CompoundTag();
            blockpos.putInt("linkX", target.getX());
            blockpos.putInt("linkY", target.getY());
            blockpos.putInt("linkZ", target.getZ());
            list.add((Object)blockpos);
        }
        tag.put("link", (Tag)list);
        return tag;
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        ListTag list = new ListTag();
        for (BlockPos target : this.link) {
            CompoundTag blockpos = new CompoundTag();
            blockpos.putInt("linkX", target.getX());
            blockpos.putInt("linkY", target.getY());
            blockpos.putInt("linkZ", target.getZ());
            list.add((Object)blockpos);
        }
        pTag.put("link", (Tag)list);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        ListTag list = (ListTag)pTag.get("link");
        this.link.clear();
        for (Tag i : list) {
            CompoundTag blockpos = (CompoundTag)i;
            this.link.add(new BlockPos(blockpos.getInt("linkX"), blockpos.getInt("linkY"), blockpos.getInt("linkZ")));
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide) {
            BlockPosNetworks networks = (BlockPosNetworks)this.level.getData(AttachmentTypeRegistry.ENDER_PEARL_NETWORKS);
            if (!networks.graph.containsVertex((Object)this.getBlockPos())) {
                networks.graph.addVertex((Object)this.getBlockPos());
            }
        }
    }
}

