/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.pearlnetwork;

import com.cmdpro.datanessence.api.misc.BlockPosNetworks;
import com.cmdpro.datanessence.api.pearlnetwork.PearlNetworkBlockEntity;
import com.cmdpro.datanessence.api.util.PlayerDataUtil;
import com.cmdpro.datanessence.config.DataNEssenceConfig;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import java.awt.Color;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jgrapht.graph.DefaultEdge;

public class PearlNetworkBlock
extends Block {
    public PearlNetworkBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static Color getColor() {
        return new Color(122, 92, 255);
    }

    public static Item getLinkItem() {
        return ItemRegistry.ESSENCE_REDIRECTOR.get();
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity entity;
        Item requiredItem = PearlNetworkBlock.getLinkItem();
        boolean success = pPlayer.getItemInHand(pHand).is(requiredItem);
        if (!pLevel.isClientSide() && (entity = pLevel.getBlockEntity(pPos)) instanceof PearlNetworkBlockEntity) {
            PearlNetworkBlockEntity ent = (PearlNetworkBlockEntity)entity;
            if (pPlayer.getItemInHand(pHand).is(requiredItem)) {
                Object t;
                BlockPosNetworks networks = (BlockPosNetworks)pLevel.getData(AttachmentTypeRegistry.ENDER_PEARL_NETWORKS);
                Optional linkFrom = (Optional)pPlayer.getData(AttachmentTypeRegistry.LINK_FROM);
                if (!linkFrom.isPresent()) {
                    if (this.canConnectFrom()) {
                        pPlayer.setData(AttachmentTypeRegistry.LINK_FROM, Optional.of(ent));
                        PlayerDataUtil.updateData((ServerPlayer)pPlayer);
                        pLevel.playSound(null, pPos, (SoundEvent)SoundRegistry.PEARL_NETWORK_LINK_FROM.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else if (this.canConnectTo((BlockEntity)linkFrom.get()) && (t = linkFrom.get()) instanceof PearlNetworkBlockEntity) {
                    PearlNetworkBlockEntity other = (PearlNetworkBlockEntity)((Object)t);
                    if (ent != linkFrom.get() && (ent.link.isEmpty() || !ent.link.contains(((BlockEntity)linkFrom.get()).getBlockPos())) && ((BlockEntity)linkFrom.get()).getBlockPos().closerThan((Vec3i)ent.getBlockPos(), (double)DataNEssenceConfig.wireDistanceLimit)) {
                        networks.graph.addEdge((Object)other.getBlockPos(), (Object)pPos);
                        other.updateBlock();
                        pPlayer.setData(AttachmentTypeRegistry.LINK_FROM, Optional.empty());
                        PlayerDataUtil.updateData((ServerPlayer)pPlayer);
                        pLevel.playSound(null, pPos, (SoundEvent)SoundRegistry.PEARL_NETWORK_LINK_TO.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                }
            }
        }
        if (success) {
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pState.getBlock() != pNewState.getBlock() && pLevel.getBlockEntity(pPos) instanceof PearlNetworkBlockEntity) {
            BlockPosNetworks networks = (BlockPosNetworks)pLevel.getData(AttachmentTypeRegistry.ENDER_PEARL_NETWORKS);
            Set edges = networks.graph.edgesOf((Object)pPos);
            for (DefaultEdge i : edges) {
                BlockEntity blockEntity;
                BlockPos pos = (BlockPos)networks.graph.getEdgeSource((Object)i);
                networks.graph.removeEdge((Object)i);
                if (pos.equals((Object)pPos) || !((blockEntity = pLevel.getBlockEntity(pos)) instanceof PearlNetworkBlockEntity)) continue;
                PearlNetworkBlockEntity ent = (PearlNetworkBlockEntity)blockEntity;
                ent.updateBlock();
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public boolean canConnectTo(BlockEntity from) {
        return true;
    }

    public boolean canConnectFrom() {
        return true;
    }
}

