/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class BlockPosGraphSerialization {

    public static class SerializationGraph {
        public static final Codec<SerializationGraph> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.listOf().fieldOf("vertices").forGetter(graph -> graph.vertices), (App)SerializationEdge.CODEC.listOf().fieldOf("edges").forGetter(graph -> graph.edges)).apply((Applicative)instance, SerializationGraph::new));
        public List<BlockPos> vertices;
        public List<SerializationEdge> edges;

        public SerializationGraph(List<BlockPos> vertices, List<SerializationEdge> edges) {
            this.vertices = vertices;
            this.edges = edges;
        }

        public static DefaultDirectedGraph<BlockPos, DefaultEdge> toGraph(SerializationGraph graphSerialization) {
            DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
            for (BlockPos blockPos : graphSerialization.vertices) {
                graph.addVertex((Object)blockPos);
            }
            for (SerializationEdge serializationEdge : graphSerialization.edges) {
                graph.addEdge((Object)serializationEdge.source, (Object)serializationEdge.target);
            }
            return graph;
        }

        public static SerializationGraph fromGraph(DefaultDirectedGraph<BlockPos, DefaultEdge> graph) {
            ArrayList<BlockPos> vertices = new ArrayList<BlockPos>(graph.vertexSet());
            List<SerializationEdge> edges = graph.edgeSet().stream().map(edge -> new SerializationEdge((BlockPos)graph.getEdgeSource(edge), (BlockPos)graph.getEdgeTarget(edge))).toList();
            return new SerializationGraph(vertices, edges);
        }
    }

    public static class SerializationEdge {
        public BlockPos source;
        public BlockPos target;
        public static final Codec<SerializationEdge> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("source").forGetter(edge -> edge.source), (App)BlockPos.CODEC.fieldOf("target").forGetter(edge -> edge.target)).apply((Applicative)instance, SerializationEdge::new));

        public SerializationEdge(BlockPos source, BlockPos target) {
            this.source = source;
            this.target = target;
        }
    }
}

