/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.item;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.registry.DataComponentRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemEssenceContainer {
    protected final Map<ResourceLocation, Float> storedEssence = new Object2FloatArrayMap();
    protected final float totalEssence;
    public static final MapCodec<ItemEssenceContainer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.FLOAT).fieldOf("essence").forGetter(obj -> obj.storedEssence), (App)Codec.FLOAT.fieldOf("maxEssence").forGetter(obj -> Float.valueOf(obj.totalEssence))).apply((Applicative)instance, ItemEssenceContainer::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEssenceContainer> STREAM_CODEC = StreamCodec.of((pBuffer, pValue) -> {
        pBuffer.writeFloat(pValue.totalEssence);
        pBuffer.writeMap(pValue.storedEssence, FriendlyByteBuf::writeResourceLocation, FriendlyByteBuf::writeFloat);
    }, pBuffer -> {
        float maxEssence = pBuffer.readFloat();
        Map essence = pBuffer.readMap(FriendlyByteBuf::readResourceLocation, FriendlyByteBuf::readFloat);
        return new ItemEssenceContainer(essence, maxEssence);
    });

    public ItemEssenceContainer(float totalEssence) {
        this(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.keySet(), 0.0f);
    }

    public ItemEssenceContainer(Iterable<ResourceLocation> supportedTypes, float totalEssence) {
        this.totalEssence = totalEssence;
        for (ResourceLocation type : supportedTypes) {
            this.storedEssence.put(type, Float.valueOf(0.0f));
        }
    }

    public ItemEssenceContainer(Map<ResourceLocation, Float> types, float totalEssence) {
        this.totalEssence = totalEssence;
        this.storedEssence.putAll(types);
    }

    public static float getEssence(ItemStack stack, ResourceLocation type) {
        return stack.has(DataComponentRegistry.ESSENCE_STORAGE) ? ((ItemEssenceContainer)stack.get(DataComponentRegistry.ESSENCE_STORAGE)).storedEssence.getOrDefault(type, Float.valueOf(0.0f)).floatValue() : 0.0f;
    }

    public static void addEssence(ItemStack stack, ResourceLocation type, float amount) {
        if (stack.has(DataComponentRegistry.ESSENCE_STORAGE)) {
            ItemEssenceContainer storage = (ItemEssenceContainer)stack.get(DataComponentRegistry.ESSENCE_STORAGE);
            if (storage.storedEssence.containsKey(type)) {
                Map<ResourceLocation, Float> essence = storage.storedEssence.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                essence.put(type, Float.valueOf(Math.clamp(storage.storedEssence.get(type).floatValue() + amount, 0.0f, storage.totalEssence)));
                stack.set(DataComponentRegistry.ESSENCE_STORAGE, (Object)new ItemEssenceContainer(essence, storage.totalEssence));
            }
        }
    }

    public static void removeEssence(ItemStack stack, ResourceLocation type, float amount) {
        if (stack.has(DataComponentRegistry.ESSENCE_STORAGE)) {
            ItemEssenceContainer storage = (ItemEssenceContainer)stack.get(DataComponentRegistry.ESSENCE_STORAGE);
            if (storage.storedEssence.containsKey(type)) {
                Map<ResourceLocation, Float> essence = storage.storedEssence.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                essence.put(type, Float.valueOf(Math.clamp(storage.storedEssence.get(type).floatValue() - amount, 0.0f, storage.totalEssence)));
                stack.set(DataComponentRegistry.ESSENCE_STORAGE, (Object)new ItemEssenceContainer(essence, storage.totalEssence));
            }
        }
    }

    public static float getMaxEssence(ItemStack stack) {
        return stack.has(DataComponentRegistry.ESSENCE_STORAGE) ? ((ItemEssenceContainer)stack.get(DataComponentRegistry.ESSENCE_STORAGE)).totalEssence : 0.0f;
    }

    public static Set<ResourceLocation> getSupportedEssenceTypes(ItemStack stack) {
        return stack.has(DataComponentRegistry.ESSENCE_STORAGE) ? ((ItemEssenceContainer)stack.get(DataComponentRegistry.ESSENCE_STORAGE)).storedEssence.keySet() : Set.of();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ItemEssenceContainer)) {
            return false;
        }
        ItemEssenceContainer that = (ItemEssenceContainer)o;
        return Float.compare(this.totalEssence, that.totalEssence) == 0 && Objects.equals(this.storedEssence, that.storedEssence);
    }

    public int hashCode() {
        return Objects.hash(this.storedEssence, Float.valueOf(this.totalEssence));
    }
}

